/*
** Copyright (C) 2001 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef CDPLAYERINI_H_INCLUDED
#define CDPLAYERINI_H_INCLUDED

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


typedef vector<CString>				ASTRING;
typedef vector<CString>::iterator	ASTRING_IT;
typedef vector<ASTRING>				AASTRING;
typedef vector<ASTRING>::iterator	AASTRING_IT;

class CDPlayerIni  
{
private:
	CMutex		m_ThreadLock;
	ASTRING		m_vSection;
	AASTRING	m_vvEntries;

	int		FindItem( int nSec, const CString& strItem, CString &strVal );
	bool	RemoveSection( const CString& strSection );
	bool	IsSection( const ASTRING_IT itSec );
	int		FindSection( const CString& strSection );
	bool	IsSectionString( const CString&  strTest );
	int		InsertSection( const CString& strSection );

public:
	bool	SetValue( const CString& strSection, const CString& strItem, const CString& cVal );
	bool	SetValue( const CString& strSection, const CString& strItem, const int iVal );
	bool	SetValue( const CString& strSection, const CString& strItem, const long lVal );
	bool	SetValue( const CString& strSection, const CString& strItem, const DWORD lVal );


	CString GetValue( const CString& strSection, const CString& strItem, CString strDefault );
	INT		GetValue( const CString& strSection, const CString& strItem, const INT nDefault );
	LONG	GetValue( const CString& strSection, const CString& strItem, const LONG nDefault );
	DWORD	GetValue( const CString& strSection, const CString& strItem, const DWORD nDefault );

	void	Clear();

	bool	Write( const CString& strFileName );
	bool	Read( const CString& strFileName );

	CDPlayerIni( );
	virtual ~CDPlayerIni();

};

#endif
