/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef CDPROPPAGE_INCLUDED
#define CDPROPPAGE_INCLUDED

#include "Resource.h"

/////////////////////////////////////////////////////////////////////////////
// CDPropPage dialog

class CDPropPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CDPropPage)
	CString		m_strTitle;
// Construction
public:
	int			m_nReadBlkSize;
	int			m_nReadOverlap;
	int			m_nBlockCompare;
	CComboBox	m_ReadMethod;
	CComboBox	m_CDRomList;
	UINT		m_nCDSpeed;

	// CONSRUCTOR
	CDPropPage();

	// DESTRUCTOR
	~CDPropPage();

	// MUTATORS
	afx_msg BOOL OnApply();
	void UpdateControls();

	void	GetCDParams();
	void	SetCDParams();

	void	FillCDRiveSelection();


// Dialog Data
	//{{AFX_DATA(CDPropPage)
	enum { IDD = IDD_CDPROPPAGE };
	CButton	m_UseNtScsi;
	BOOL	m_bSwapChannels;
	BOOL	m_bJitter;
	int		m_nStartOffset;
	int		m_nEndOffset;
	int		m_nSpinUpTime;
	BOOL	m_bAspiPosting;
	int		m_nRetries;
	BOOL	m_bEjectWhenFinished;
	BOOL	m_bSelectAll;
	BOOL	m_bUseNtScsi;
	BOOL	m_bFirstBlockOnly;
	BOOL	m_bMultipleRead;
	int		m_nMultipleReadCount;
	BOOL	m_bLockDuringRead;
	CComboBox	m_RippingMethod;
	BOOL	m_bUseCDText;
	//}}AFX_DATA


	void	EnDisAbleControls();

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CDPropPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CDPropPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnDetect();
	afx_msg void OnSelchangeCdromlist();
	afx_msg void OnJitter();
	afx_msg void OnSelchangeRippingmethod();
	afx_msg void OnUsentscsi();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


#endif
