/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef CDDB_H_INCLUDED
#define CDDB_H_INCLUDED

#include <Winsock.h>
#include <AfxSock.h>
#include "CDdbDlg.h"
#include "TextFile.h"
#include "config.h"

/** 
 * CDInfo Foreward Class declaration
 */
class CDInfo;


/** 
 * Define the CDDB batch file name
 */
#define CDDB_BATCH_FNAME g_config.GetCDDBPath() + _T( "CDDB_Batch.txt" )
#define CDDB_BATCH_FNAME_TMP	( CDDB_BATCH_FNAME + _T( ".tmp" ) )

/** 
 * CDdb is a class to obtain (load/get) or store (save/put) CD related information
 */
class CDdb
{

public:
	/** 
	 * class constructor
	 */
	CDdb(	
			CDInfo* pCDInfo,	//! pointer to a CDInfo object
			CWnd*	pWnd		//! pointer to Wnd object
		);

	/** 
	 * class destructor
	 */
	~CDdb();

	//! Obtain CDDB data from local CDDB database    
	/*!
     \return TRUE if query is successful, otherwise FALSE
    */
	BOOL	QueryLocal();

	/** 
	 * Writes the current CDDB data to the local CDDB database
	 */
	BOOL	WriteCurrentEntry();

	/** 
	 * Obtain CDDB data from remote CDDB database
	 */
	BOOL	QueryRemote( );

	/** 
	 * Obtain a server list from the remote site
	 */
	BOOL	QuerySites();

	/** 
	 * Writes the current CDDB data to the remote CDDB database
	 */
	BOOL	SubmitRemote( );

	/** 
	 * Add or remove the current entry from the CDDB batch list
	 */
	BOOL	AddRemoveQueryBatch( //! returns FALSE if successful
									BOOL bAdd //! Add or remove entry
								);				//! returns TRUE if successful

	static CString GetCDDBAction();
	static CString GetInfoMsg();
	BOOL RemoveFromCDDBBatch( const CString& strLine );

private:
	void		GetRealServerName();
	int			GetString( CString& strRet);
	BOOL		SendProto();
	BOOL		SendStat();
	int			SendRemoteMessage( CString& strSend, BOOL bQuery );
	int			SendString(CString strSend, BOOL bAppendLineFeed=TRUE);
	int			SendString_UTF( CHAR* strSend, BOOL bAppendLineFeed=TRUE );
	CString		CreateHttpSendString( CString strSend );

	void		EncodeEmailAddress( CString& strEmailAddress );

	int			SendAuthentication();
	BOOL		CheckServerResponse(CString strCheck, BOOL bQuery );
	BOOL		HandleMultipleMatches( );
	CDEX_ERR	OpenConnection(CString strAddress = _T( "" ),int nPort = 80 );
	BOOL		CloseConnection();
	BOOL		SendHello();
	BOOL		SendQuery();
//	void		ReceiveMessage();
	BOOL		GetLogOnMessage();

	BOOL	GetRemoteSites();

	CString		GetWindowCDDBFileName( const CString& strCategoryDir );
	CString		GetCategoryDir( DWORD dwCategory );

	BOOL	CheckFrameOffsets( CTextFile& cReadFile );
	LONG	SearchEntryInFiles( CString& strFileName );
	LONG	SearchEntry( CString& strFileName, CString& strCategory );
	BOOL	ParseData( const CString& strToParse );
	BOOL	ReadEntry( const CString& strFileName, long lFilePos );
	BOOL	ReadRarEntry( const CString& strFileName );

	void	WriteLine( CTextFile& cWriteFile, const CString& strName, const CString& strValue );
	BOOL	WriteEntry( const CString& strFileName, bool bIsWindowsTypeDB, bool bIsDosFileType );
	BOOL	RemoveEntry( CString& strFileName );
	BOOL	InitWinSock();
	CString GenerateFileName( const CString& strCategory );
	void	SetCategory( const CString& strCategory );

	BOOL	GetHostName( CString &szFullyQualifiedHostName );
	BOOL	SendSmtpString( const CString& strSend, int nNotOkValue );
	BOOL	SmtpOpenConnection( const CString& strAddr, int nPort );
	CString EncodeBASE64( CString szMessage );

	int		SendStringQuotedPrintable( const CString& strSend );

	BOOL	SendSmtp(
						const CString& strServer,
						const int nPort,
						const CString& strMailTo,
						const CString& strMailFrom,
						const CString& strMailSubject,
						const CString& strMailBody 
					);
	CString GetClientVersion();

	BOOL StoreToCDDBBatch( const CString& strLine );


	void SetInfoMsg( const CString& strMsg );
	void SetCDDBAction( const CString& strAction );


private:
	/** 
	 * CDdb disc ID string
	 */	
	CString		m_strDiscID;

	/** 
	 * The local CDDB path name
	 */	
	CString		m_strLocalPath;

	CDInfo*		m_pCDInfo;
	BOOL		m_bFirstOpenConnection;
//	CInternetSession m_pInetSession

	// A buffer to hold the receive data
	char		m_lpszBuffer[4*8192];

	// For server
    sockaddr_in sAddrServer;
	CString		m_strServer;
	CSocket		m_Socket;

	BOOL		m_bConnected;
	CString		m_strRemoteServer;

	CString		m_strReadID;
	CString		m_strReadCat;
	CString		m_strReceive;

	BOOL					m_bInexact;
	BOOL					m_bIsUnixCDDBType;
	BOOL					m_bUTF;

	static CWnd*			m_pWnd;
	static CMutex			m_mInfoMsg;
	static CString			m_strInfoMsg;	
	static CMutex			m_mCDDBAction;
	static CString			m_strCDDBAction;	
	const  CString			m_strSubmitFileName;
};


#endif