/*
** Copyright (C) 1999 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef CHILEPROCESS_H_INCLUDED
#define CHILEPROCESS_H_INCLUDED

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CChildProcess : public CObject
{
public:
	virtual BOOL WaitForFinish( DWORD Timeout );
	virtual BOOL StartProcess();
	CChildProcess(BOOL abConsole, const CString& strCommandLine, DWORD aPriorityClass, HANDLE hIn, HANDLE hOut, HANDLE hErr, BOOL bHideWindow );
	virtual ~CChildProcess();

	BOOL SubstituteParameter( const CString& strFrom, const CString& strTo );

protected:
	DWORD	m_dwPriorityClass;
	DWORD	m_dwExitCode;
	BOOL	m_bConsole;
	HANDLE	m_hProcess;
	CString m_strCommandLine;
	HANDLE	m_hStdin;
	HANDLE	m_hStdout;
	HANDLE	m_hStderr;
	BOOL	m_bHideWindow;
};

#endif // CHILEPROCESS_H_INCLUDED
