/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "stdafx.h"
#include "config.h"
#include "cdex.h"
#include "ConfigDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define WIN_ENCODER_ENABLED		
#ifdef _DEBUG
#endif


BOOL g_bEncPresent=FALSE;
BOOL g_bEncDllPresent=FALSE;
BOOL g_bHasBladeMP3=FALSE;




/////////////////////////////////////////////////////////////////////////////
// ConfigSheet

IMPLEMENT_DYNAMIC(ConfigSheet, CPropertySheet)


ConfigSheet::ConfigSheet( int nSelectTab,CWnd* pParentWnd )
	: CPropertySheet( IDS_PROPSHEET_CDEXCONFIG, pParentWnd )
{
	// translate property sheet title
	SetTitle( g_language.GetString( IDS_PROPSHEET_CDEXCONFIG ) );

	m_psh.dwFlags |= PSH_NOAPPLYNOW;	// Construct pages

	AddPage( &m_GenericPropPage );
	AddPage( &m_FilenamePropPage );
	AddPage( &m_CDPropPage );
	AddPage( &m_EncoderPropPage );
	AddPage( &m_LocalCDDBPropPage );
	AddPage( &m_RemoteCDDBPropPage );

	ASSERT( nSelectTab>=0 && nSelectTab<4);

	m_bIsInSync = FALSE;

	// Select Active Page
	SetActivePage( nSelectTab );
}


ConfigSheet::~ConfigSheet()
{
}

BOOL ConfigSheet::OnApply()
{
	if ( FALSE == m_bIsInSync )
	{
		if (m_CDPropPage.m_hWnd!=NULL) m_CDPropPage.UpdateControls();
		if (m_EncoderPropPage.m_hWnd!=NULL) m_EncoderPropPage.UpdateControls();
		if (m_GenericPropPage.m_hWnd!=NULL) m_GenericPropPage.UpdateControls();
		if (m_RemoteCDDBPropPage.m_hWnd!=NULL) m_RemoteCDDBPropPage.UpdateControls();
		if (m_FilenamePropPage.m_hWnd!=NULL) m_FilenamePropPage.UpdateControls();
		if (m_LocalCDDBPropPage.m_hWnd!=NULL) m_LocalCDDBPropPage.UpdateControls();

		g_config.Save();

		m_bIsInSync = TRUE;
	}

	return 0;
}

BEGIN_MESSAGE_MAP(ConfigSheet, CPropertySheet)
	//{{AFX_MSG_MAP(ConfigSheet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ConfigSheet message handlers






void CRemoteCDDBPropPage::OnResetbutton() 
{
	// Clear all entries
	g_RemoteSites.ClearAll();

	// Add Default Entries
	g_RemoteSites.AddDefaultSites();

	GetRemoteServers();

	m_nLastServerSelection=0;

	// Set the new selection
	UpdateCtrls();
}

void CRemoteCDDBPropPage::OnAddsite() 
{
	UpdateControls();

	g_RemoteSites.AddSite("localhost","localserver","/~cddb/cddb.cgi",80,OPTIONS_CDDB_USEHTTP,TRUE);
	CString strTmp("localhost http  80 ( localserver )");

	int nNewSelection = m_ServerList.InsertString( -1, strTmp );

	m_ServerList.SetCurSel( nNewSelection );

	// Set the new selection
	UpdateCtrls();

	m_nLastServerSelection = nNewSelection;

}

void CRemoteCDDBPropPage::OnChangeLocation() 
{
	OnChangeAddress();
}

void CRemoteCDDBPropPage::OnChangeHttppath() 
{
	OnChangeAddress();
}

void CRemoteCDDBPropPage::OnSelchangeProtocol() 
{
	OnChangeAddress();
}

void CRemoteCDDBPropPage::OnChangeAddress() 
{
	UpdateData( TRUE );
	
	int nCurrentSelection = m_ServerList.GetCurSel( );

	CString strTmp( m_strAddress );

	if ( m_cddbProtocol.GetCurSel()==OPTIONS_CDDB_USEHTTP)
	{
		strTmp += _T( " http " );
	}
	else
	{
		strTmp += _T( " cddbp " );
	}

	CString strPort;

	strPort.Format( _T( " %d " ), m_nCDDBPort );
	strTmp += strPort;

	strTmp += _T( " (" ) + m_strLocation + _T( ")" );

	// Replace combo string
	m_ServerList.DeleteString( nCurrentSelection );

	m_ServerList.InsertString( nCurrentSelection, strTmp );

	m_ServerList.SetCurSel( nCurrentSelection );

	UpdateData( FALSE );
}

void CRemoteCDDBPropPage::OnSelchangeServerlist() 
{
	// update the current settings
	UpdateControls();

	// Set the new selection
	UpdateCtrls();

	// Set the last active server selection
	m_nLastServerSelection = m_ServerList.GetCurSel();
}



