/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef CONFIGDLG_INCLUDED
#define CONFIGDLG_INCLUDED

#include "Config.h"
#include "Resource.h"

#include "CDPropPage.h"
#include "LocalCDDBPropPage.h"
#include "RemoteCDDBPropPage.h"
#include "GenericPropPage.h"
#include "FilenamePropPage.h"
#include "EncoderPropPage.h"



// ConfigSheet

class ConfigSheet : public CPropertySheet
{
	DECLARE_DYNAMIC(ConfigSheet)

private:
	BOOL				m_bIsInSync;
// Construction
public:
	CDPropPage			m_CDPropPage;
	CEncoderPropPage	m_EncoderPropPage;
	CGenericPropPage	m_GenericPropPage;
	CRemoteCDDBPropPage	m_RemoteCDDBPropPage;
	CFilenamePropPage	m_FilenamePropPage;
	CLocalCDDBPropPage	m_LocalCDDBPropPage;
	// CONSTRUCTORS
	ConfigSheet( int nSelectTab,CWnd* pParentWnd=NULL);

	// DESTRUCTOR
	virtual ~ConfigSheet();

	// MUTATORS
	virtual afx_msg BOOL OnApply();

protected:
	// And hook in the message map
	DECLARE_MESSAGE_MAP()
};



/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.







#endif



