// DropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "cdex.h"
#include "DropDlg.h"
#include "config.h"
#include "Util.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDropDlg dialog


CDropDlg::CDropDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDropDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDropDlg)
	//}}AFX_DATA_INIT
	m_bDeleteWAV = g_config.GetDeleteWAV();
	m_bRiffWAV = g_config.GetRiffWav();
	m_bNormalize=FALSE;
	m_bEncode=FALSE;
}


void CDropDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDropDlg)
	DDX_Check(pDX, IDC_DELETEWAV, m_bDeleteWAV);
	DDX_Check(pDX, IDC_RIFFWAV, m_bRiffWAV);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDropDlg, CDialog)
	//{{AFX_MSG_MAP(CDropDlg)
	ON_BN_CLICKED(IDC_ENCODE, OnEncode)
	ON_BN_CLICKED(IDC_NORMALIZE, OnNormalize)
	ON_BN_CLICKED(IDC_NORMANDENC, OnNormandenc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDropDlg message handlers

void CDropDlg::OnEncode() 
{
	UpdateData(TRUE);
	g_config.SetRiffWav( m_bRiffWAV );
	g_config.SetDeleteWAV(m_bDeleteWAV);
	m_bEncode=TRUE;
	CDialog::OnOK();
}

void CDropDlg::OnNormalize() 
{
	UpdateData(TRUE);
	g_config.SetRiffWav( FALSE );
	g_config.SetDeleteWAV(FALSE);
	m_bNormalize=TRUE;
	CDialog::OnOK();
	
}

void CDropDlg::OnNormandenc() 
{
	UpdateData(TRUE);
	g_config.SetRiffWav( m_bRiffWAV );
	g_config.SetDeleteWAV(m_bDeleteWAV);
	m_bNormalize=TRUE;
	m_bEncode=TRUE;
	CDialog::OnOK();
}

void CDropDlg::OnCancel() 
{
	CDialog::OnCancel();
}

BOOL CDropDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// translate dialog controls
	g_language.InitDialogStrings( this, IDD_DROPASK );

	return TRUE;
}
