/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef ENCODERDOS_H_INCLUDED
#define ENCODERDOS_H_INCLUDED

#include "Encode.h"

class CEncoderDos : public CEncoder
{
public:
	// CONSTRUCTOR
	CEncoderDos();

	// DESTRUCTOR
	virtual ~CEncoderDos();

	// METHODS
	virtual CDEX_ERR InitEncoder( CTaskInfo* pTask );
	virtual CDEX_ERR OpenStream(CString strOutFileName,DWORD dwSampleRate,WORD nChannels);
	virtual CDEX_ERR EncodeChunk(PSHORT pbsInSamples,DWORD dwNumSamples);
	virtual CDEX_ERR CloseStream();
	virtual CDEX_ERR DeInitEncoder();
	virtual CDEX_ERR DosEncode(	const CString& strInFileName,
								const CString& strInFileExt, 
								const CString& strOutFileName,
								const CString& strOutDir,
								INT&  nPercent,
								BOOL& bAbort);
	virtual	CEncoderDlg*	GetSettingsDlg();

	virtual void SaveSettings();
	virtual void LoadSettings();

	BOOL GetAddStdinWavHeader() const { return m_bSendStdinWavHeader;}
	void SetAddStdinWavHeader( BOOL bValue ) { m_bSendStdinWavHeader = bValue;}

protected:
	DWORD CalculateChildPriorityClass();

	// MEMBERS
	HANDLE			m_hReadPipe;
	HANDLE			m_hWritePipe;
	CChildProcess*	m_pChildProcess;
	CString			m_strTempFileName;
	CString			m_strOutFileName;
	BOOL			m_bSendStdinWavHeader;
	// METHODS
	CString PrepareCommandLine();

};

class CAacEncoder:public CEncoderDos
{
public:
	// CONSTRUCTOR
	CAacEncoder();

	// DESTRUCTOR
	virtual ~CAacEncoder();
	virtual CEncoderDlg* GetSettingsDlg();
	virtual CDEX_ERR DosEncode(	const CString& strInFileName,
								const CString& strInFileExt, 
								const CString& strOutFileName,
								const CString& strOutDir,
								INT&  nPercent,
								BOOL& bAbort);
};

class CAacPsyEncoder:public CAacEncoder
{
public:
	// CONSTRUCTOR
	CAacPsyEncoder();

	// DESTRUCTOR
	virtual ~CAacPsyEncoder();
};


#endif /* ENCODERDOS_H_INCLUDED */

