/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "StdAfx.h"
#include "EncoderDosXing.h"
#include "EncoderDosXingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

INITTRACE( _T( "EncoderDosXing" ) );


CEncoderDosXing::CEncoderDosXing():CEncoderDos()
{
	m_bRiffWavSupport = TRUE;
	m_strEncoderPath = _T( "" );
	m_strExtension = _T( "mp3" );
	m_strEncoderID = _T( "External Xing Encoder" );
	m_nEncoderID = ENCODER_EXTXING;
	LoadSettings();

	m_bCanWriteTagV1 = TRUE;
	m_bCanWriteTagV2 = TRUE;

}

CEncoderDosXing::~CEncoderDosXing()
{
}

CEncoderDlg* CEncoderDosXing::GetSettingsDlg()
{
	if (!m_pSettingsDlg)
	{
		m_pSettingsDlg=new CEncoderDosXingDlg;
	}
	return m_pSettingsDlg;
}


CDEX_ERR CEncoderDosXing::DosEncode(const CString& strInFileName,
									const CString& strInFileExt, 
									const CString& strOutFileName,
									const CString& strOutDir,
									INT&  nPercent,
									BOOL& bAbort)
{
	// Prepare user string based on the Xing encoder settings
	m_strUser2 = _T( "%1 %2" );

	if (GetOriginal()==0)		// Turn off Original flag
	{
		m_strUser2 += _T( " -o" );
	}

	if (GetCopyRight()==0)	// Turn off copyright flag
	{
		m_strUser2 += _T( " -c" );
	}

	if ( (GetUserN1()>>0)&0x01 )	 //Downmix To Mono
	{
		m_strUser2 += _T( " -d" );
	}

	if ( (GetUserN1()>>1)&0x01 )	// FilterHighFreq
	{
		m_strUser2 += _T( " -l" );
	}

	if ( (GetUserN1()>>2)&0x01 )	// SimpleStereo
	{
		m_strUser2 += _T( " -s" );
	}

	if ( (GetUserN1()>>3)&0x01 )	// Let Encoder choose sample rate
	{
		m_strUser2 += _T( " -r" );
	}

	if ( GetMode() == 0 )		// is CBR or VBR
	{
		// CBR
		m_strUser2 += _T( " -b %3" );
		
	}
	else
	{
		// VBR
		CString strTmp;
		strTmp.Format( _T( " -v %d" ), GetUserN2() );
		m_strUser2+=strTmp;
	}

	// Call parent method
	return CEncoderDos::DosEncode(strInFileName, strInFileExt, strOutFileName, strOutDir, nPercent, bAbort );
}

