/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "StdAfx.h"
#include "EncoderWAVFixed.h"
#include "Encode.h"
#include "config.h"
#include "EncoderWavDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

INITTRACE( _T( "EncoderWAVFixed" ) );

// CWAVEncoder CONSTRUCTOR
CEncoderWAVFixed::CEncoderWAVFixed()
	:CEncoderWAV()
{
}


// CEncoderWAVFixed DESTRUCTOR
CEncoderWAVFixed::~CEncoderWAVFixed()
{
}



CDEX_ERR CEncoderWAVFixed::OpenStream( CString strOutFileName,DWORD dwSampleRate,WORD nChannels )
{
	int nFormat=0;
	int	nCompression=0;
	int nTest=-1;

	USES_CONVERSION;

	ENTRY_TRACE( _T( "CEncoderWAVFixed::OpenStream" ) );

//	pTest=fopen("f:\\cdextest\\test.raw","wb+");

	memset(&m_wfInfo,0,sizeof(SF_INFO));

	// Retain number of input channels
	m_nInputChannels=nChannels;


	m_dResampleRatio = 1;

	m_wfInfo.samplerate  = dwSampleRate;
	m_wfInfo.frames      = -1;
	m_wfInfo.sections	 = 1;
	m_wfInfo.channels    = nChannels;

	nCompression = SF_FORMAT_PCM_16;

	m_strExtension = _T( "wav" );

	nFormat = SF_FORMAT_WAV;

	m_wfInfo.format = ( nFormat | nCompression );

	// Open stream
	if ( !( m_pSndFile = sf_open(	strOutFileName +  _T( "." ) + GetExtension(), 
									SFM_WRITE,
									&m_wfInfo ) ) )
	{
			ASSERT( FALSE );
		return CDEX_ERROR;
	}

	m_bDownMixToMono = FALSE;
	m_bUpMixToStereo = FALSE;


	// Set converter size TODO: Remove hardcoded value
	// INPUT BUFFER SIZE IN SAMPLES, THUS SHORTS
	m_dwInBufferSize = 8192;

	// Allocate Output Buffer size
	m_pbOutputStream= new BYTE[ m_dwInBufferSize ];

	// Initialize input stream
	InitInputStream();

	m_strEncoderID = _T( "PCM WAV file" );

	EXIT_TRACE( _T( "CEncoderWAVFixed::OpenStream" ) );

	// Everything went OK
	return CDEX_OK;
}
