/*
** Copyright (C) 1999 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


/*******************************************************************************

 FILENAME:		FileUtil.cpp
 PROJECT:		none
 PURPOSE:		Provide CFile IO Stream operators for Core Exception objects

 REMARKS:		none

 *******************************************************************************/

// INCLUDES

#include "stdafx.h"
#include "FileUtil.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  operator>> - open an CArchive to get overload >> as file read.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
inline CFile& operator>>(CFile &f, CString &str)
{
	CArchive ar(&f,CArchive::load);
	ar >> str;
	ar.Close();
	return f;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  operator<< - open an CArchive to get overload >> as file read.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
inline CFile& operator<<(CFile &f, CString &str)
{
	CArchive ar(&f,CArchive::store);
	ar << str;
	ar.Close();
	return f;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  operator>> - open an CArchive to get overload >> as file read.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
inline CFile& operator>>(CFile &f, CString &str)
{
	return operator>>(f,(CString&)str);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  operator<< - open an CArchive to get overload >> as file read.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
inline CFile& operator<<(CFile &f, CString &str)
{
	return operator<<(f,(CString&)str);
}

