/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "StdAfx.h"
#include "GenericPropPage.h"
#include "config.h"
#include "ConfigDlg.h"
#include "CDex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGenericPropPage property page

IMPLEMENT_DYNCREATE(CGenericPropPage, CPropertyPage)

CGenericPropPage::CGenericPropPage()
	: CPropertyPage( CGenericPropPage::IDD )
{

	m_strTitle  = g_language.GetString( IDS_GENERICPROPPAGE );
	m_psp.pszTitle = m_strTitle;
	m_psp.dwFlags |= PSP_USETITLE;


	m_nLNormFactor= g_config.GetLNormFactor();
	m_nHNormFactor= g_config.GetHNormFactor();
	m_bNormTrack  = g_config.GetNormTrack();
	m_nLNormLevel = g_config.GetLowNormLevel();
	m_nUNormLevel = g_config.GetHighNormLevel();

	if ( NULL != m_ID3Version.m_hWnd )
	{
		m_ID3Version.SetCurSel( g_config.GetID3Version() );
	}

	m_strComment =  g_config.GetID3Comment();
	m_strEncodedBy =  g_config.GetID3EncodedBy();
	m_bAutoShutDown = g_config.GetAutoShutDown();
	m_nID3V2TrkNrType = g_config.GetID3V2TrackNumber();
	m_bDigitalCDPlay = g_config.GetCDPlayDigital();

	//{{AFX_DATA_INIT(CGenericPropPage)
	//}}AFX_DATA_INIT
}

CGenericPropPage::~CGenericPropPage()
{
}

void CGenericPropPage::DoDataExchange(CDataExchange* pDX)
{
	CString strLang;

	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGenericPropPage)
	DDX_Check(pDX, IDC_NORMTRACK, m_bNormTrack);
	DDX_Text(pDX, IDC_LNORMLEVEL, m_nLNormLevel);
	DDX_Text(pDX, IDC_UNORMLEVEL, m_nUNormLevel);
	DDX_Control(pDX, IDC_ID3VERSION, m_ID3Version);
	DDX_Text(pDX, IDC_ID3COMMENT, m_strComment);
	DDX_Text(pDX, IDC_ID3V2ENCODEDBY, m_strEncodedBy); // Hydra
	DDX_Text(pDX, IDC_LNORMVALUE, m_nLNormFactor);
	DDV_MinMaxInt(pDX, m_nLNormFactor, 1, 100);
	DDX_Text(pDX, IDC_HNORMVALUE, m_nHNormFactor);
	DDV_MinMaxInt(pDX, m_nHNormFactor, 1, 100);
	DDX_Check(pDX, IDC_AUTOSHUTDOWN, m_bAutoShutDown);
	DDX_CBIndex(pDX, IDC_TRACKNUMBERSETTING, m_nID3V2TrkNrType);
	DDX_Check(pDX, IDC_DIGITALCDPLAYBACK, m_bDigitalCDPlay);
	//}}AFX_DATA_MAP
	// Set Folder selection 
	strLang = g_language.GetString( IDS_PLEASE_SELECTFOLDER );
	DDX_GetFolderControl(pDX, IDC_TEMPDIR, m_tmpDir, 0, strLang );
}



BOOL CGenericPropPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	// translate dialog resources
	g_language.InitDialogStrings( this, IDD );

	((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN1))->SetRange( 1, 100 );
	((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN2))->SetRange( 0, 100 );
	((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN3))->SetRange( 0, 100 );
	((CSpinButtonCtrl*)GetDlgItem(IDC_SPIN4))->SetRange( 1, 100 );

	m_tmpDir.SetWindowText( g_config.GetTempDir() );

	m_ID3Version.SetCurSel( g_config.GetID3Version() );

	return TRUE;
}

void CGenericPropPage::UpdateControls()
{
	CString strTmp;

	UpdateData(TRUE);

	g_config.SetLNormFactor( ( m_nLNormFactor<1 )?1:m_nLNormFactor );
	g_config.SetHNormFactor( ( m_nHNormFactor<1 )?1:m_nHNormFactor );
	g_config.SetNormTrack( m_bNormTrack );
	g_config.SetLowNormLevel( m_nLNormLevel );
	g_config.SetHighNormLevel( m_nUNormLevel );
	g_config.SetID3EncodedBy( m_strEncodedBy );

	m_tmpDir.GetWindowText( strTmp );

	if ( !strTmp.IsEmpty() )
	{
		// Add trailing back space
		if ( strTmp[ strTmp.GetLength()-1 ] != '\\' )
		{
			strTmp +=  _T( "\\" );
		}
	}

	g_config.SetTempDir( strTmp );

	g_config.SetID3Version( m_ID3Version.GetCurSel() );
	g_config.SetID3Comment( m_strComment );

	g_config.SetAutoShutDown( m_bAutoShutDown );
	g_config.SetID3V2TrackNumber( CConfig::ID3TRKNRTTYPE( m_nID3V2TrkNrType ) );

	g_config.SetCDPlayDigital( m_bDigitalCDPlay );

}


BOOL CGenericPropPage::OnApply()
{
	// Call parent to update all property sheets
	((ConfigSheet*)GetParent())->OnApply();

	// Do default stuff
	return CPropertyPage::OnApply();
}

void CGenericPropPage::OnChange() 
{
  SetModified(TRUE);
}

void CGenericPropPage::ID3VersionChange()
{
	UpdateControls();
}


BEGIN_MESSAGE_MAP(CGenericPropPage, CPropertyPage)
	//{{AFX_MSG_MAP(CGenericPropPage)
	ON_BN_CLICKED(IDC_NORMTRACK, OnChange)
	ON_EN_CHANGE(IDC_LNORMLEVEL, OnChange)
	ON_EN_CHANGE(IDC_NORMVALUE, OnChange)
	ON_EN_CHANGE(IDC_UNORMLEVEL, OnChange)
	ON_CBN_SELCHANGE(IDC_ID3VERSION, ID3VersionChange) // Hydra
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
