/*
** Copyright (C) 2001 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef GENRETABLE_H_INCLUDED
#define GENRETABLE_H_INCLUDED

class GENRETABLEENTRY
{
public:
	BYTE		nID3V1ID;
	CString		strGenre;
	CString		strCDDBGenre;
	bool		bCanBeModified;
	bool		operator < ( const GENRETABLEENTRY& rhs ) const { if ( strGenre.Compare( rhs.strGenre) > 0 ) return false; else return true; }
};

class CGenreTable : public CObject
{
public:
	// CONSTRUCTOR
	CGenreTable();
	// DESTRUCTOR
	~CGenreTable();

	int Load( CString strFileName );
	void Save( CString strFileName );

	DWORD GetNumGenres() const { return v_Entries.size(); }

	BYTE	GetID3V1ID( WORD wIdx ) const;
	void	SetID3V1ID( WORD wIdx, BYTE nValue );

	CString GetGenre( WORD wIdx ) const;
	void	SetGenre( WORD wIdx, CString strValue );

	CString GetCDDBGenre( WORD wIdx ) const;
	void	SetCDDBGenre( WORD wIdx, CString strValue );

	int		SearchGenre( CString strSearch ) const;

	bool	CanBeModified( WORD wIdx );

	CString GetID3V1GenreString( int nID3TagIdx ) const;

	int		SearchID3V1ID( int btSearch ) const;

	void	DeleteAll() { v_Entries.clear(); }
	void	Sort();

	void	AddDefaults();
	int		AddEntry( INT nID3V1ID, const CString& strGenre, const CString& strCDDBGenre, bool bCanBeModified  );

	void	FreeWinampRange( DWORD& dwStart, DWORD& dwEnd );

private:
	vector<GENRETABLEENTRY> v_Entries;
};

#endif
