#include "StdAfx.h"
#include "HistEdit.h"
#include "Util.h"

static const int DEF_NUM_HIST_LINES=250;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


CHistEdit::CHistEdit()
	:CEdit()
{
	m_nLines=0;
	m_nHistLines=DEF_NUM_HIST_LINES;
}

CHistEdit::~CHistEdit()
{
}

void CHistEdit::AddString(const CString& strAdd, bool bAddReturn)
{
	m_nLines++;

	if (GetLineCount()>m_nHistLines)
	{
		int nPos=m_strHist.Find(_T("\n"));
		if (nPos>=0)
		{
			m_strHist=m_strHist.Right(m_strHist.GetLength()-nPos-2);
		}
	}

	// Add the new string

	CString strNew;

	strNew.Format(_T("%s%s"), m_strHist, strAdd );
//	m_strHist= m_strHist + strAdd;

	m_strHist = strNew;


	// Add return if this is not the first string
	if (!m_strHist.IsEmpty() )
	{
		if ( bAddReturn )
			m_strHist+=_T("\r\n");
	}

	// Put the string into CEdit control
	SetWindowText( m_strHist );

	// Scroll the edit control
	LineScroll( GetLineCount()-1, 0 );

}


void CHistEdit::SetLogging( const CString& strFileName, bool bEnable )
{
	m_strLogFileName= strFileName;
	m_bLogEnabled= bEnable;
}