/* 
   Copyright Albert L Faber (c) 2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ISNDSTREAMMPEG_H_INCLUDED
#define ISNDSTREAMMPEG_H_INCLUDED

#include <math.h>
#include "ISndStream.h"

#include "mpglibdll/mpglibdll.h"
#include "MPEGHeader.h"


#define MPEG_WAV_BUFFERSIZE 4602


class ISndStreamMPEG : public ISndStream
{
public:
	// CONSTRUCTOR
	ISndStreamMPEG();

	// DESTRUCTOR
	virtual ~ISndStreamMPEG();

	//MUTATORS
	virtual BOOL	OpenStream(CString strFileName);
	virtual DWORD	Read(PBYTE pbData,DWORD dwNumBytes);
	virtual BOOL	CloseStream();
	virtual LONG	Seek( LONG lOff, UINT nFrom );
	virtual void	Flush();
	virtual VOID	InfoBox( HWND hWnd );

	// ACCESSORS
	virtual DWORD	GetTotalTime();
	virtual DWORD	GetCurrentTime();

private:
	FILE*		m_pFile;
	BYTE		m_pbDataInBuffer[MPEG_WAV_BUFFERSIZE];
	MPEGHeader	m_Header;
	HINSTANCE	m_hDLL;
	int			m_dwTotalFileSize;
	int			m_dwCurrentFilePos;
	DWORD		m_dwBytesToDo;
	DWORD		m_dwSkipBytes;

	MPGLIB_OPENSTREAM	m_pOpenStream;
	MPGLIB_DECODECHUNK	m_pDecode;
	MPGLIB_CLOSESTREAM	m_pCloseStream;
	MPGLIB_VERSION		m_pVersion;
	MPGLIB_GETBITRATE	m_pGetBitRate;
	MPGLIB_FLUSH		m_pFlush;
	H_STREAM			m_hStream;
};




#endif