/* 
   Copyright Albert L Faber (c) 2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ISNDSTREAMWINAMP_H_INCLUDED
#define ISNDSTREAMWINAMP_H_INCLUDED

#include "ISndStream.h"

extern "C"
{
	#include "in2.h"
//	#include "out.h"
}

typedef struct WINAMPPLUGINPROP_TAG
{
	CString		strExt;
	CString		strFileName;
	HINSTANCE	hDll;
	In_Module*	pModule;

}	WINAMPPLUGINPROP;


class ISndStreamWinAmp : public ISndStream
{
	DWORD				m_dwSamples;
	WINAMPPLUGINPROP	m_WinAmpProp;
public:
	ISndStreamWinAmp();
	virtual ~ISndStreamWinAmp();
	virtual BOOL	OpenStream(CString strFileName);
	virtual DWORD	Read(PBYTE pbData,DWORD dwNumBytes);
	virtual BOOL	CloseStream();
	virtual __int64	Seek( __int64 ddwOffset, UINT nFrom );
	virtual void	Flush();
	virtual void	Pause();
	
	virtual DWORD	GetTotalTime();
	virtual DWORD	GetCurrentTime();
	virtual VOID	InfoBox( HWND hWnd );

private:
	int		m_dwCurrentFilePos;
	int		m_dwTotalFileSize;

	void	FlushFIFO( );


};


void InitWinAmpPlugins( HWND hWnd );
void DeInitWinAmpPlugins(  );

void WinampPlugInFinished();
int GetNumWinampPlugins();
CString GetWinampPluginInfo( int i );
CString GetWinampPluginFileName( int i );
void WinampPluginAbout( int i, HWND hWnd );
void WinampPluginConfigure( int i, HWND hWnd );
CString GetWinampFileNameExt();

void WinampPluginInfoBox( LPSTR lpszFileName, HWND hWnd );

#endif