/*
** Copyright(C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
**(at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 - 1307, USA.
*/

#ifndef LANGUAGE_H_INCLUDED
#define LANGUAGE_H_INCLUDED

#include <vector>
using namespace std;


class CLangElement
{
public:
	int		nID;
	CString	strValue;
};


class CLanguage : public CObject  
{
public:
	/**
	 * Language constructor 
	 */
	CLanguage( );

	/**
	 * Language destructor 
	 */
	virtual ~CLanguage();

	BOOL	SetLanguage( const CString& strLanguage );

	CString	GetLanguageString( const DWORD dwIndex ) const;
	DWORD	GetNumLanguageStrings() const { return m_vLangFiles.size(); }

	void Init( const CString& strLanguageDir, const CString& strLanguage );
//	BOOL SetLanguage( const int nLanguageIdx );

	CString	GetMainMenuItem( const DWORD nID, const DWORD nItem );
	CString	GetSubMenuItem( const DWORD nID );
	CString	GetDialogString( const DWORD nID );
	CString	GetString( const DWORD nID ) const;

	BOOL TranslateMenu( CMenu* pMenu, const int nMenuID, BOOL bTopLevel = TRUE );
	BOOL InitDialogStrings( CDialog* pDialog, long lSection );

	CString	GetLanguage() const;

	DWORD	GetCodePage() const {return m_dwCodePageID;}
	CString	AsciiToUnicode( PCHAR lpszIn  );

	CString GetRevisionLevel( const CString& strFileName );
	
private:
	void SearchLanguageFiles( );
	void ParseLanguageFile( const CString& strFileName );
	void TranslateTab( CString& strModify );
	void ReportMissingID( int nID, const CString& strEnglish, int nType ) const;
	void EncodeTab( CString& strModify ) const;

	void SetFont( CWnd* pWnd );

	CString					m_strCurrentLanguage;
	vector<CString>			m_vLangFiles;
	vector<CLangElement>	m_vMenus;
	vector<CLangElement>	m_vStrings;
	vector<CLangElement>	m_vDialogs;
	CString					m_strLanguageDir;
	DWORD					m_dwCodePageID;
	DWORD					m_dwSubLangID;
	DWORD					m_dwLangID;

	static const CString	DEFAULT_LANG_SELECTION;
	static const CString    CODEPAGETAG;
	static const CString    LANGTAG;
	static const CString    SUBLANGTAG;
	static const CString    REVISIONTAG;
	static const CString	m_strLangFileExt;
};

#endif

