/*
** Copyright (C) 1999 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef LINELISTINCLUDED
#define LINELISTINCLUDED

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// LineList.h : header file
//
/////////////////////////////////////////////////////////////////////////////
// LListCtrl window

class LListCtrl : public CListCtrl
{
// Construction
	BOOL m_bEditNext;
public:
    LListCtrl():CListCtrl() { m_bEditNext = FALSE;};
    virtual ~LListCtrl() {};
	BOOL GetEditNext() const { return m_bEditNext; }
	VOID SetEditNext( BOOL bValue ) { m_bEditNext = bValue;}
// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(LListCtrl)
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
public:
	int		GetCurSel() const;
	int		SetCurSel(int nSelect);
	void	OnPrint(CString strHeader="",CString strFooter="",DWORD dwFlags=0);
	int		SelectAll();
	int		SelectNone();

	void	SetHeaderControlText( DWORD dwPos, const CString& strValue );

private:
	void print_header(CDC *pDC, CRect crPrintedPage, CSize csCharSize, CPoint& cpCurPos, CString& strHeader, DWORD dwFlags);
	void print_line(CDC *pDC, CRect crPrintedPage, CSize csCharSize, CPoint& cpCurpos, DWORD dwLine);
	void print_footer(CDC *pDC, CRect crPrintedPage, CSize csCharSize, CString& strFooter, DWORD dwPage, DWORD dwPagesTotal);

// Generated message map functions
protected:
    //{{AFX_MSG(LListCtrl)
	afx_msg void OnInsertitem(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEndlabeledit(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnClick(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
      DECLARE_MESSAGE_MAP()

public:
// DoPrint flags:
	enum Flags
	{
		LLC_LANDSCAPE	= 0x0001,
		LLC_HDRNODATE	= 0x0002,
		LLC_HDRNOTIME	= 0x0004,
	};
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif
