/*
** Copyright (C) 1999 Albert L Faber <al.faber@hccnet.nl>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* OSndStream.cpp */

#include "StdAfx.h"
#include "OSndStreamWAV.h"


// CONSTRUCTOR
OSndStreamWAV::OSndStreamWAV()
	:OSndStream()
{
	SetStreamType( SNDSTREAM_WAV );
	m_pSndFile=NULL;
	SetFileExtention( _T( "wav" ) );
	m_OutputFormat = SF_FORMAT_PCM_16;
	SetSampleRate( 44100 );
	SetChannels( 2 );
}

// DESRUCTOR
OSndStreamWAV::~OSndStreamWAV()
{
	CloseStream();
}


//BOOL OSndStreamWAV::Write(PBYTE pbData,DWORD dwNumBytes, double dUpSampleRatio, double dScale )
BOOL OSndStreamWAV::Write(PBYTE pbData,DWORD dwNumBytes )
{

	if ( sf_write_short( m_pSndFile, (short*)pbData, dwNumBytes / 2 ) == dwNumBytes )
		return TRUE;
	return FALSE;
}

BOOL OSndStreamWAV::OpenStream( CString strFileName )
{
	SF_INFO wfInfo;
	USES_CONVERSION;

	memset(&wfInfo,0,sizeof(SF_INFO));
	wfInfo.samplerate  = GetSampleRate();
	wfInfo.frames      = -1;
	wfInfo.sections	   = 1;
	wfInfo.channels    = GetChannels();
	wfInfo.format      = (SF_FORMAT_WAV | m_OutputFormat) ;

	// Set file name
	SetFileName(strFileName);
	
	// Open stream
	if (! (m_pSndFile = sf_open(	GetFileName() + _T( "." ) + GetFileExtention(),
									SFM_WRITE,
									&wfInfo ) ) )
	{
		ASSERT( FALSE );
		return FALSE;
	}

	// return Success
	return TRUE;
}

BOOL OSndStreamWAV::CloseStream()
{
	if (m_pSndFile)
	{
		if ( sf_close(m_pSndFile) !=0 )
		{
			ASSERT( FALSE );
			return FALSE;
		}
		m_pSndFile=NULL;
	}
	return TRUE;
}

