/* Copyright (c) 1998 Sasha Djolich */
/* For questions or comments, contact the author at djolic@netinfo.ubc.ca */


#pragma once


class CRegistry
{
public:
	enum
	{
		modeCurrentUserPrefs = 0,
		modeDefUserPrefs,
		modeLocalMachineProps,
		
		accessRead  = 0x1,
		accessWrite = 0x2,
	};

// Construction/Destruction
public:
	CRegistry(const CString& strApplicationName, int Mode = modeCurrentUserPrefs, int Access = accessRead | accessWrite);
	CRegistry(HKEY Area, const CString& strRootSection, int Access = accessRead | accessWrite);
	~CRegistry();
	
// Attributes
public:
	void SetRootSection(const CString& strApplicationName, int Mode = modeCurrentUserPrefs);
	void SetRootSection(HKEY Area, const CString& strRootSection );

	void SetAccess(int Access = accessRead | accessWrite);

// Iteration
public:
	POSITION	GetFirstKeyPos();
	CString		GetNextKey(POSITION& Pos);

	POSITION	GetFirstSectionPos();
	CString		GetNextSection(POSITION& Pos);

// Operations
public:
	void Descend(const char* Section);
	void Ascend();

	bool KeyExists(const CString& strKey);
	bool SectionExists(const CString& strSection);

	void Store(const CString& strKey, signed char Value);
	void Store(const CString& strKey, unsigned char Value);
	void Store(const CString& strKey, signed short Value);
	void Store(const CString& strKey, unsigned short Value);
	void Store(const CString& strKey, signed int Value);
	void Store(const CString& strKey, unsigned int Value);
	void Store(const CString& strKey, signed long Value);
	void Store(const CString& strKey, unsigned long Value);
	void Store(const CString& strKey, float Value);
	void Store(const CString& strKey, double Value);
	void Store(const CString& strKey, const CString& Value);

	void Restore(const CString& strKey, signed char& Value);
	void Restore(const CString& strKey, unsigned char& Value);
	void Restore(const CString& strKey, signed short& Value);
	void Restore(const CString& strKey, unsigned short& Value);
	void Restore(const CString& strKey, signed int& Value);
	void Restore(const CString& strKey, unsigned int& Value);
	void Restore(const CString& strKey, signed long& Value);
	void Restore(const CString& strKey, unsigned long& Value);
	void Restore(const CString& strKey, float& Value);
	void Restore(const CString& strKey, double& Value);
	void Restore(const CString& strKey, CString& Value);

private:
	void OpenRoot(HKEY Area, const CString& RootSection, int Access);
	void Close();

	void StoreDWORD(const CString& strKey, DWORD Value);
	void StoreString(const CString& strKey, const CString& Value);

	void RestoreDWORD(const CString& strKey, DWORD& Value);
	void RestoreString(const CString& strKey, CString& Value);

	HKEY	mRootArea;
	CString mRootSection;
	
	HKEY	mActiveSectionKey;
	CString mActiveSection;

	int		mAccess;
};
