/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "StdAfx.h"

#include "RipInfoDB.h"
#include "Config.h"

void CRipInfoDB::Init()
{
	m_pFile = NULL;
	m_nTrack = -1;
	m_strFileName= _T( "" );
}


CRipInfoDB::CRipInfoDB()
{
	Init();
}

CRipInfoDB::~CRipInfoDB()
{
	if ( m_pFile )
	{
		fclose( m_pFile );
		m_pFile = NULL;
	}
}

void CRipInfoDB::SetFileName( CString strFileName )
{
	CString strOutPath = g_config.GetCDDBPath() + _T( "Status\\" );

	// And test it, no dialog please
	DoesDirExist( strOutPath, FALSE );

	m_strFileName = strOutPath + strFileName + _T( ".txt" );
}

void CRipInfoDB::DeleteTrack( int nTrack )
{
	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "r" ) );

	if ( NULL != m_pFile )
	{
		FILE* pFileOut = _tfopen( m_strFileName + _T( ".bak" ), _T( "w+" ) );

		while( ( !feof( m_pFile ) )  && ( pFileOut != NULL ) )
		{
			TCHAR	lpszLine[ 1024 ] = {'\0',};
			int		nCurrentTrack;

			// Clear string
			memset( lpszLine, 0x00, sizeof( lpszLine ) );

			// Read the next line from the file
			_fgetts( lpszLine, sizeof( lpszLine ), m_pFile );

			nCurrentTrack= _ttoi( &lpszLine[ 1 ] );

			if ( nCurrentTrack != nTrack )
			{
				_fputts( lpszLine, pFileOut );
			}
		}

		fclose( m_pFile );
		fclose( pFileOut );

		m_pFile = NULL;

		DeleteFile( m_strFileName );
		MoveFile( m_strFileName + _T( ".bak"), m_strFileName );
		DeleteFile( m_strFileName + _T( ".bak" ) );
	}
}

void CRipInfoDB::SetCurrentTrack( int nTrack )
{
	m_nTrack = nTrack;
}

CDEX_ERR CRipInfoDB::GetStatusInfo( int nTrack, DWORD& dwJitterErrors )
{
	BOOL	bFinishedProperly = FALSE;
	BOOL	bPresentInDB = FALSE;
	BOOL	bAborted = FALSE;
	CDEX_ERR result = CDEX_OK;
	
	dwJitterErrors = 0;

	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "r" ) );

	if ( NULL != m_pFile )
	{
		// Loop through all entries
		while( !feof( m_pFile ) )
		{
			TCHAR	lpszLine[ 1024 ] = {'\0',};
			int		nCurrentTrack;

			// Clear string
			memset(lpszLine,0x00,sizeof(lpszLine));

			// Read the next line from the file
			_fgetts(	lpszLine,
						sizeof( lpszLine ),
						m_pFile );

			// Get track number
			nCurrentTrack = _ttoi( &lpszLine[ 1 ]  );

			if ( nCurrentTrack == nTrack ) 
			{
				bPresentInDB=TRUE;

				switch ( lpszLine[ 6 ] )
				{
					case 'J':	dwJitterErrors++ ; break;
					case 'A':	bAborted = TRUE; break;
					case 'C':	bFinishedProperly = TRUE; break;
				}
			}
		}

		fclose( m_pFile );

		m_pFile = NULL;
	}

	if ( dwJitterErrors > 0 )
	{
		result = CDEX_JITTER_ERROR;
	}
	else if ( bAborted )
	{
		result = CDEX_ERROR;
	}
	else if ( bPresentInDB && bFinishedProperly )
	{
		result = CDEX_RIPPING_DONE;
	}

	return result;
}

void CRipInfoDB::SetRipInfo(CString strRipInfo)
{
	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "a+" ) );

	if ( NULL != m_pFile )
	{
		TCHAR lpszOut[ 1024 ] = {'\0'};

		_stprintf( lpszOut, _T( "[%03d][I] : %s\n" ), m_nTrack, strRipInfo );

		_fputts( lpszOut, m_pFile );

		fclose( m_pFile );

		m_pFile = NULL;
	}
}



void CRipInfoDB::SetRipInfoFinshedOK(CString strRipInfo)
{
	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "a+" ) );

	if ( m_pFile )
	{
		TCHAR lpszOut[1024] = {'\0'};

		_stprintf( lpszOut, _T( "[%03d][C] : %s\n" ), m_nTrack, strRipInfo );

		_fputts( lpszOut, m_pFile );

		fclose( m_pFile );

		m_pFile = NULL;
	}
}

void CRipInfoDB::SetJitterError( int nSectorStart, int nSectorEnd, int nTrackSectorBegin )
{
	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "a+" ) );

	if ( NULL != m_pFile )
	{
		char lpszOut[1024] = {'\0',};

		sprintf(	lpszOut,
					"[%03d][J] : Jitter error detected (not corrected!) near %d:%02d [m:s] (range %d - %d [ms], absolute %d - %d [sectors])\n",
					m_nTrack,
					( ( nSectorStart - nTrackSectorBegin ) / 75 ) / 60,
					( ( nSectorStart - nTrackSectorBegin ) / 75 ) % 60,
					( nSectorStart - nTrackSectorBegin ) * 1000 / 75,
					( nSectorEnd - nTrackSectorBegin ) * 1000 / 75,
					nSectorStart,
					nSectorEnd );

		fputs( lpszOut, m_pFile );
		fclose( m_pFile );
		m_pFile = NULL;
	}
}


void CRipInfoDB::SetAbortError(CString strAbortInfo)
{
	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "a+" ) );

	if ( NULL != m_pFile )
	{
		char lpszOut[ 1024 ] = { '\0',};

		sprintf(	lpszOut,
					"[%03d][A] : %s\n",
					m_nTrack,
					strAbortInfo );

		fputs( lpszOut, m_pFile );
		fclose( m_pFile );
		m_pFile = NULL;
	}
}


CString CRipInfoDB::GetRipInfo( int nTrack )
{
	CString strRet("");

	// Open file for append
	m_pFile = _tfopen( m_strFileName, _T( "r" ) );

	if ( NULL != m_pFile )
	{
		// Loop through all entries
		while( !feof( m_pFile ) )
		{
			TCHAR	lpszLine[1024];
			int		nCurrentTrack;

			// Clear string
			memset(lpszLine,0x00,sizeof(lpszLine));

			// Get the current line
			_fgetts(lpszLine,sizeof(lpszLine),m_pFile);

			// Get track number
			nCurrentTrack = _ttoi(&lpszLine[1]);

			if ( nCurrentTrack == nTrack ) 
			{
				CString strTmp( lpszLine );
				strTmp = strTmp.Mid( 11 );
				strRet += strTmp + _T( "\r\n" ) ;
			}
		}
		fclose( m_pFile );
		m_pFile = NULL;
	}

	if (!strRet.IsEmpty())
	{
		strRet += _T( "\r\n" );
	}
	return strRet;
}

void CRipInfoDB::RemoveAll()
{
	// Open file for append
	::DeleteFile( m_strFileName );
}