/*
** Copyright (C) 1999-2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef RIPINFODB_INCLUDED
#define RIPINFODB_INCLUDED

#include "Config.h"

class CRipInfoDB : public CObject
{
private:
	FILE*	m_pFile;
	int		m_nTrack;
	CString	m_strFileName;

public:
	CRipInfoDB();
	~CRipInfoDB();
	void SetFileName( CString strFileName );
	void DeleteTrack( int nTrack );
	void SetCurrentTrack( int nTrack );
	CDEX_ERR GetStatusInfo( int nTrack, DWORD& dwJitterErrors );
	void SetRipInfo(CString strRipInfo);
	void SetRipInfoFinshedOK(CString strRipInfo);
	CString GetRipInfo( int nTrack );
	void SetJitterError( int nSectorStart, int nSectorEnd, int nTrackSectorBegin );
	void SetAbortError( CString strAbortInfo );
	void RemoveAll();

	void Init();
};


#endif