/*
** Copyright (C) 2000 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "StdAfx.h"

#include "SndStreamFactory.h"

#include "ISndStreamWAV.h"
//#include "ISndStreamMPEG.h"
//#include "ISndStreamOGG.h"
#include "ISndStreamWMA.h"
#include "ISndStreamWinAmp.h"


ISndStream* ICreateStream(CString& strFileName)
{
	ISndStream* sndStream=NULL;

		// Get extention of filename
	CString strExt=strFileName.Right(3);

	// Make it lower case for comparison
	strExt.MakeLower();

	// Is this an MP2 or MP3 file
	if ( strExt == _T( "mp3" ) || strExt == _T( "mp2" ) ) 
	{
//		sndStream=new ISndStreamMPEG;
		sndStream=new ISndStreamWinAmp;
	} else if (strExt=="wav") 
	{
		sndStream=new ISndStreamWAV;

	} else if (strExt == _T( "wma" ) ) 
	{
		sndStream=new ISndStreamWMA;
	} else
	{
		sndStream=new ISndStreamWinAmp;
	}

	return sndStream;
}



CString GetInFileNameExt()
{
	CString strExt = GetWinampFileNameExt();
	if ( !strExt.IsEmpty() )
		strExt+= ";";

	strExt+="OGG;WAV;MP3;MP2;MP1;WMA";

	return strExt;
}
