/*
** Copyright (C) 2000 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <StdAfx.h>
#include <limits.h>
#include "TaskInfo.h"
#include "Config.h"
#include "FileName.h"

const double CTaskInfo::NORM_TUNE_FACTOR   = 0.99999;
const double CTaskInfo::NORM_DEFAULT_VALUE = 1.00000;


CTaskInfo::CTaskInfo()
{
	m_strName			= _T( "" );
	m_strTrackName		= _T( "" );
	m_strArtist			= _T( "" );
	m_strAlbum			= _T( "" );
	m_strYear			= _T( "" );
	m_strGenre			= _T( "" );
	m_strNonSplitArtist = _T( "" );
	m_dwCDBID			= 0;
	m_dwVOLID			= 0;

	m_dwStartSector		= 0;
	m_dwEndSector		= 0;
	m_dwTrack			= 0;

	m_dwTotalTracks		= 0;
	m_strOutDir			= _T( "" );
	m_strOutName		= _T( "" );

	m_nEncoderType		= ENCODER_FIXED_WAV;
	m_strMCDI			= _T( "" );

	m_dwLengthInMs		= 0;

	m_bRip				= FALSE;
	m_bNormalize		= FALSE;
	m_bConvert			= FALSE;
	m_bDeleteWav		= FALSE;
	m_bRiffWav			= FALSE;
	m_nPeakValue		= INT_MAX;
	m_dNormalizationFactor = NORM_DEFAULT_VALUE ;
	m_lTrackOffset		= 0;

	memset( m_btaRawToc, 0 , sizeof( m_btaRawToc ) );
}

CTaskInfo::~CTaskInfo()
{
}


CTaskInfo& CTaskInfo::operator=(const CTaskInfo& rhs)
{
	// avoid self assignment
	if (&rhs==this)
		return *this;

	m_strName			= rhs.m_strName;
	m_strTrackName		= rhs.m_strTrackName;
	m_strArtist			= rhs.m_strArtist;
	m_strAlbum			= rhs.m_strAlbum;
	m_strYear			= rhs.m_strYear;
	m_strGenre			= rhs.m_strGenre;
	m_strNonSplitArtist = rhs.m_strNonSplitArtist;
	m_dwCDBID			= rhs.m_dwCDBID;
	m_dwVOLID			= rhs.m_dwVOLID;

	m_dwStartSector		= rhs.m_dwStartSector;
	m_dwEndSector		= rhs.m_dwEndSector;
	m_dwTrack			= rhs.m_dwTrack;

	m_dwTotalTracks		= rhs.m_dwTotalTracks;
	m_strOutDir			= rhs.m_strOutDir;
	m_strOutName		= rhs.m_strOutName;

	m_nEncoderType		= rhs.m_nEncoderType;
	m_strMCDI			= rhs.m_strMCDI;

	m_dwLengthInMs		= rhs.m_dwLengthInMs;

	m_bRip				= rhs.m_bRip;
	m_bNormalize		= rhs.m_bNormalize;
	m_bConvert			= rhs.m_bConvert;
	m_bDeleteWav		= rhs.m_bDeleteWav;
	m_bRiffWav			= rhs.m_bRiffWav;
	m_nPeakValue		= rhs.m_nPeakValue ;
	m_dNormalizationFactor = rhs.m_dNormalizationFactor ;
	m_lTrackOffset		= rhs.m_lTrackOffset ;

	memcpy( m_btaRawToc, rhs.m_btaRawToc, sizeof( m_btaRawToc ) );

	return *this;
}

CTaskInfo::CTaskInfo(const CTaskInfo& rhs)
{
	operator=(rhs);
}


CString CTaskInfo::GetOutDir() const 
{
	return m_strOutDir;
}

CString CTaskInfo::GetTrackName() const 
{
	return m_strTrackName;
}

CString CTaskInfo::GetArtist() const 
{
	return m_strArtist;
}

CString CTaskInfo::GetNonSplitArtist() const 
{
	return m_strNonSplitArtist;
}

CString CTaskInfo::GetAlbum() const 
{
	return m_strAlbum;
}

CString CTaskInfo::GetMCDI() const 
{
	return m_strMCDI;
}

CString CTaskInfo::GetYear() const 
{
	return m_strYear;
}

CString CTaskInfo::GetGenre() const 
{
	return m_strGenre;
}


DWORD CTaskInfo::GetCDBID() const 
{
	return m_dwCDBID;
}

DWORD CTaskInfo::GetVOLID() const 
{
	return m_dwVOLID;
}


DWORD CTaskInfo::GetStartSector() const 
{
	return m_dwStartSector;
}

DWORD CTaskInfo::GetEndSector() const 
{
	return m_dwEndSector;
}

DWORD CTaskInfo::GetTrack() const 
{
	return m_dwTrack;
}

DWORD CTaskInfo::GetLengthInMs() const 
{
	return m_dwLengthInMs;
}



CString CTaskInfo::GetInDir() const 
{
	// get the full path name string
	CString strTmp=m_strName;

	// find the last backslash
	int nPos=strTmp.ReverseFind('\\');

	// return everything before the last backslash
	return strTmp.Left(nPos+1);
}

void CTaskInfo::SetInDir( CString strDir ) 
{
	// get the file name, path excluded 
	CString strTmp = GetFileName( );

	if ( strDir[ strDir.GetLength() - 1 ] != '\\' )
	{
		strDir += _T( "\\" );
	}

	SetFullFileName( strDir + strTmp );

}


CString CTaskInfo::GetFullFileName( ) const 
{
	return m_strName;
}


CString CTaskInfo::GetFullFileNameNoExt( ) const 
{
	CString strTmp=m_strName;

	int nPos=strTmp.ReverseFind( _T( '.' ) );

	// there is a DOT somewhere
	if (nPos)
	{
		// cut everything after the last ., . included
		strTmp = strTmp.Left(nPos);
	}

	// return resulting string
	return strTmp;
}

CString CTaskInfo::GetFileName( ) const 
{
	// get the full path name string
	CString strTmp=m_strName;

	// find the last backslash
	int nPos=strTmp.ReverseFind('\\');

	// return everything after the last backslash
	return strTmp.Right(strTmp.GetLength()-nPos-1);
}

CString CTaskInfo::GetFileNameNoExt( ) const 
{
	// get the full path name string
	CString strTmp=m_strName;

	// find the last backslash
	int nPosS=strTmp.ReverseFind('\\');
	int nPosE=strTmp.ReverseFind('.');

	if (nPosE<0) nPosE=strTmp.GetLength();

	if ( (strTmp.GetLength()-nPosE)>4)
		nPosE=strTmp.GetLength();
	// return everything before the last backslash

	return strTmp.Mid(nPosS+1,nPosE-nPosS-1);
}


void CTaskInfo::BuildFileName( CString& strName,CString& strDir )
{
	CString strBuild[ NUMFILENAME_IDS ];
	
	// Build playlist filename
	strBuild[ 0] =GetArtist( );									// %1 = Artist
	strBuild[ 1] =GetAlbum( );									// %2 = Album
	strBuild[ 2].Format( _T( "%d" ), GetTrack( ) + GetTrackOffset() );				// %3 = Track Number
	strBuild[ 3] =GetTrackName( );								// %4 = Track Name
	strBuild[ 4].Format( _T( "%08x" ), GetVOLID( ) );				// %5 = CD VolumeID
	strBuild[ 5].Format( _T( "%08x" ), GetCDBID( ) );				// %6 = CDDB ID 
	strBuild[ 6].Format( _T( "%02d" ), GetTrack( ) + GetTrackOffset() ); //%7 = Track Number Leading Zero
	strBuild[ 7].Format( _T( "%02d" ), GetTotalTracks( ) + GetTrackOffset() ); // %8 = Total Number of Tracks
	strBuild[ 8] = GetYear( );									// %Y = Year
	strBuild[ 9] = GetGenre( );									// %G = Genre
	strBuild[10] = GetNonSplitArtist( );							// %A = Artist Name (not affected by the split option)

	// Build the new file name
	::BuildFileName( g_config.GetFileFormat(), strBuild, strName, strDir );
}


CString CTaskInfo::GetFileExt( ) const 
{
	// get the full path name string
	CString strTmp=m_strName;

	// find the last dot
	int nPos=strTmp.ReverseFind('.');

	if (nPos)
		return strTmp.Right(strTmp.GetLength()-nPos-1);

	return "";
}

void CTaskInfo::SetFileExt( CString str)
{
	// get the full path name string
	CString strTmp( m_strName );

	// find the last dot
	int nPos = strTmp.ReverseFind( _T( '.' ) );

//	int nTst=strTmp.GetLength();
//	if ( (strTmp.GetLength()-nPos)<=4 && nPos>=0)
	if ( nPos >= 0 )
	{
		strTmp=strTmp.Left( nPos );
	}

	// Set the file name + extention
	m_strName = strTmp + _T( "." ) + str;
}


CString CTaskInfo::GetOutFullFileName( ) const 
{
	return m_strOutName;
}


CString CTaskInfo::GetOutFullFileNameNoExt( ) const 
{
	CString strTmp=m_strOutName;

	int nPos=strTmp.ReverseFind('.');

	// there is a DOT somewhere
	if (nPos)
	{
		// return everything except the file extention
		return strTmp.Left(nPos);
	}

	// no extention found, return entire string
	return strTmp;
}


CString CTaskInfo::GetOutFileName() const 
{
	// get the full path name string
	CString strTmp=m_strOutName;

	// find the last backslash
	int nPos=strTmp.ReverseFind('\\');

	// return everything after the last backslash
	return strTmp.Right(strTmp.GetLength()-nPos-1);
}

CString CTaskInfo::GetOutFileNameNoExt( ) const 
{
	// get the full path name string
	CString strTmp=m_strOutName;

	// find the last backslash
	int nPosS=strTmp.ReverseFind('\\');
	int nPosE=strTmp.ReverseFind('.');

	if (nPosE<0) nPosE=strTmp.GetLength();

//	if ( (strTmp.GetLength()-nPosE)>4)
//		nPosE=strTmp.GetLength();
	// return everything before the last backslash

	strTmp = strTmp.Mid(nPosS+1,nPosE-nPosS-1);

	return strTmp;
}

CString CTaskInfo::GetOutFileExt( ) const 
{
	// get the full path name string
	CString strTmp( m_strOutName );

	// find the last dot
	int nPos=strTmp.ReverseFind('.');

	if (nPos)
		return strTmp.Right( strTmp.GetLength()-nPos-1 );

	return "";
}


void CTaskInfo::SetOutFileExt( CString str )
{
	// get the full path name string
	CString strTmp( m_strName );

	// find the last dot
	int nPos=strTmp.ReverseFind( _T( '.' ) );

	int nTst=strTmp.GetLength();

//	if ( (strTmp.GetLength()-nPos)<=4 && nPos>=0)
	if ( nPos >= 0 )
	{
		strTmp = strTmp.Left( nPos );
	}

	// Set the file name + extention
	m_strOutName = strTmp + "." + str;
}

void CTaskInfo::SetEncoderType( ENCODER_TYPES nType )
{
	m_nEncoderType = nType;
}

int CTaskInfo::GetPeakValue( ) const 
{
	return m_nPeakValue;
}
