/*
** Copyright (C) 2000-2004 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef TASK_H_INCLUDED
#define TASK_H_INCLUDED

#include "Encode.h"

class CTaskInfo
{
public:
static const double NORM_TUNE_FACTOR;
static const double NORM_DEFAULT_VALUE;

private:
	CString			m_strName;
	CString			m_strTrackName;
	CString			m_strArtist;
	CString			m_strAlbum;
	CString			m_strYear;
	CString			m_strGenre;
	CString			m_strNonSplitArtist;
	CString			m_strMCDI;
	DWORD			m_dwCDBID;
	DWORD			m_dwVOLID;
	DWORD			m_dwStartSector;
	DWORD			m_dwEndSector;
	DWORD			m_dwTrack;
	DWORD			m_dwTotalTracks;
	DWORD			m_dwLengthInMs;
	CString			m_strOutDir;
	CString			m_strOutName;
	ENCODER_TYPES	m_nEncoderType;
	BOOL			m_bRip;
	BOOL			m_bNormalize;
	BOOL			m_bConvert;
	BOOL			m_bDeleteWav;
	BOOL			m_bRiffWav;
	int				m_nPeakValue;
	double			m_dNormalizationFactor;
	DWORD			m_lTrackOffset;
	RAW_TOC_TYPE	m_btaRawToc;

public:

	// CONSTRUCTOR
	CTaskInfo();
	CTaskInfo( const CTaskInfo& rhs );
	
	// DESTRUCTOR
	virtual ~CTaskInfo();

	// METHODS
	CTaskInfo& operator=(const CTaskInfo& rhs);

	CString		GetInDir( ) const ;
	void		SetInDir( CString strDir );

	CString		GetOutDir( ) const;

	CString		GetFullFileName( ) const;
	CString		GetFileName( ) const;
	CString		GetFullFileNameNoExt( ) const ;
	CString		GetFileNameNoExt( ) const ;
	CString		GetFileExt( ) const ;
	void		SetFileExt( CString str);

	CString		GetOutFullFileName( ) const;
	CString		GetOutFileName( ) const;
	CString		GetOutFullFileNameNoExt( ) const ;
	CString		GetOutFileNameNoExt( ) const ;
	CString		GetOutFileExt( ) const ;
	void		SetOutFileExt( CString str);

	CString		GetTrackName( ) const;
	CString		GetArtist( ) const;
	CString		GetAlbum( ) const;
	CString		GetYear( ) const;
	CString		GetGenre( ) const;
	DWORD		GetCDBID( ) const;
	DWORD		GetVOLID( ) const;
	CString		GetNonSplitArtist( ) const;

	CString		GetMCDI( ) const;
	void		SetMCDI( const CString& str ) { m_strMCDI = str; }

	BYTE*		GetRawToc() const { return (BYTE*)m_btaRawToc; }
	void		SetRawToc( BYTE* btaRawToc ) { memcpy( m_btaRawToc, btaRawToc, sizeof( RAW_TOC_TYPE ) ); }

	DWORD		GetStartSector( ) const;
	DWORD		GetEndSector( ) const;
	DWORD		GetTrack( ) const;
	DWORD		GetTotalTracks( ) const {return  m_dwTotalTracks;}

	DWORD		GetLengthInMs( ) const;

	void		SetFullFileName( CString str) { m_strName = str;}
	void		SetOutFullFileName( CString str) { m_strOutName = str;}
	void		SetOutDir( CString str) { m_strOutDir = str;}
	
	void		SetTrackName( CString str) { m_strTrackName=str;}
	void		SetArtist( CString str) { m_strArtist=str;}
	void		SetAlbum( CString str) { m_strAlbum=str;}
	void		SetYear( CString str) { m_strYear=str;}
	void		SetGenre( CString str) { m_strGenre=str;}
	void		SetNonSplitArtist( CString str) { m_strNonSplitArtist=str;}

	void		SetCDBID( DWORD val) { m_dwCDBID=val;}
	void		SetVOLID( DWORD val) { m_dwVOLID=val;}

	void		SetStartSector( DWORD val) { m_dwStartSector=val;}
	void		SetEndSector( DWORD val) { m_dwEndSector=val;}
	void		SetTrack( DWORD val) { m_dwTrack=val;}
	void		SetTotalTracks( DWORD val) { m_dwTotalTracks=val;}
	void		SetLengthInMs( DWORD val) { m_dwLengthInMs=val;}

	void		BuildFileName( CString& strName,CString& strDir);

	LONG		GetTrackOffset() const {return m_lTrackOffset;}
	void		SetTrackOffset( LONG lValue ) { m_lTrackOffset = lValue; }

	ENCODER_TYPES	GetEncoderType( ) const { return  m_nEncoderType; }
	void			SetEncoderType(  ENCODER_TYPES nType );

	BOOL		GetRip() const			{ return m_bRip; }
	void		SetRip( BOOL nValue )			{ m_bRip = nValue; }

	BOOL		GetNormalize() const	{ return m_bNormalize; }
	void		SetNormalize( BOOL nValue )		{ m_bNormalize = nValue; }

	BOOL		GetConvert() const		{ return m_bConvert; }
	void		SetConvert( BOOL nValue )		{ m_bConvert = nValue; }

	BOOL		GetDeleteWav() const	{ return m_bDeleteWav; }
	void		SetDeleteWav( BOOL nValue )		{ m_bDeleteWav = nValue; }

	BOOL		GetRiffWav() const		{ return m_bRiffWav; }
	void		SetRiffWav( BOOL nValue )		{ m_bRiffWav = nValue; }

	void		SetPeakValue( int nValue )		{ m_nPeakValue = nValue; }
	int			GetPeakValue( ) const;

	void		SetNormalizationFactor( DOUBLE dValue ) { m_dNormalizationFactor = dValue;}
	DOUBLE		GetNormalizationFactor( ) const { return m_dNormalizationFactor;}
};

#endif
