/*
** Copyright (C) 2000 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef CTasks_H_INCLUDED
#define CTasks_H_INCLUDED

#include "ID3Tag.h"
#include "vector"
using namespace std ;


#include "TaskInfo.h"


typedef vector<CTaskInfo> RECTP;
typedef vector<CTaskInfo>::iterator	RECIT;

class CTasks
{
private:
	RECTP			m_vTasks;
//	DWORD			m_dwCurrentTrack;

public:
	// CONSTRUCTOR
	CTasks();

	// DESTRUCTOR
	virtual ~CTasks();

	// METHODS
	CTaskInfo&		GetTaskInfo( DWORD dwTask );
	DWORD			GetNumTasks() const {return m_vTasks.size();}
	INT				AddTaskInfo( CTaskInfo& newTask );
	void			ClearAll() { m_vTasks.clear(); }

};

#endif