/*
** Copyright (C) 1999-2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "StdAfx.h"
#include "TextFile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define CHAR_EOF 26
#define CHAR_LF  10
#define CHAR_CR  13

const CString CTextFile::m_strCRLF( CString( (CHAR)CHAR_CR ) + CString( (CHAR)CHAR_LF ) );
const CString CTextFile::m_strLF( CString( (CHAR)CHAR_LF ) );

IMPLEMENT_DYNAMIC( CTextFile, CObject)


// Always open the file as a binary file, the class will be
// transparent regarding unix/dos test files

CTextFile::CTextFile( )
		:CObject( ),
		m_pFile( NULL ),
		m_bWriteAsDosFile( false )

{
}



void CTextFile::SetWriteAsDosFile( bool bValue  )
{
	m_bWriteAsDosFile = bValue;
}

BOOL  CTextFile::Open( LPCTSTR lpszFileName, TEXTFILE_MODE nOpenFlags )
{
	BOOL bReturn = FALSE;

	CString strFlags;

	switch ( nOpenFlags ) 
	{
		case modeRead  : strFlags = _T( "rb" ); break;
		case modeWrite : strFlags = _T( "wb" ); break;
		case modeAppend: strFlags = _T( "ab" ); break;
		default:
			ASSERT( FALSE );
	}

	m_pFile = _tfopen( lpszFileName, strFlags );

	if ( NULL != m_pFile )
	{
		bReturn = TRUE;
	}

	return bReturn;
}


CTextFile::~CTextFile()
{
}

BOOL  CTextFile::ReadString( CString& rString )
{
	BOOL bResult = FALSE;
	int nPos = 0;
	int nInputChar;

	USES_CONVERSION;

	rString = _T("");

	vector <CHAR> vChars;


	ASSERT( m_pFile );

	while ( EOF != ( nInputChar = fgetc( m_pFile ) ) )
	{
		bResult = TRUE;

		if ( CHAR_LF == (CHAR)nInputChar ||
			 CHAR_EOF == (CHAR)nInputChar )
		{
			break;
		}
//		if ( CHAR_CR != (char)nInputChar )
		{
			vChars.push_back( (CHAR)nInputChar );
		}
	}

	// terminate string
	vChars.push_back( _T( '\0' ) );

#ifdef _UNICODE
	int nLen = strlen( &vChars[0] );

	TCHAR* lpWideString = new TCHAR[ ( nLen + 1 ) * sizeof( TCHAR ) ];

	if ( NULL != lpWideString )
	{
		// convert UTF-8 to UNICODE
		nLen = MultiByteToWideChar(	CP_UTF8, 
									0,
									&vChars[0],
									-1,
									lpWideString,
									( nLen + 1 ) * sizeof( TCHAR )  );

		rString = lpWideString;

		delete [] lpWideString;
	}
#else
	rString = CString( &vChars[0] );
#endif

	return bResult;
}

void  CTextFile::WriteString( const CString& wString )
{
	USES_CONVERSION;

	ASSERT( m_pFile );

	CString strOut( wString );

	if ( m_bWriteAsDosFile )
	{
		strOut += m_strCRLF;
	}
	else
	{
		strOut += m_strLF;
	}
#ifdef _UNICODE
	CHAR* pszUtf = new CHAR[ strOut.GetLength() * 4 ];

		// convert ASCII string to WideCharacter string based on active code page
	int nLen = WideCharToMultiByte(	CP_UTF8 , 
									0,
									strOut,
									-1,
									pszUtf,
									strOut.GetLength() * 4,
									NULL,
									NULL );

	fwrite( pszUtf, 1, nLen - 1, m_pFile );

	delete [] pszUtf;
#else
	fwrite( strOut, 1, strOut.GetLength(), m_pFile );
#endif
}

void CTextFile::Close()
{
	ASSERT( m_pFile );

	if ( m_pFile )
	{
		fclose( m_pFile );
		m_pFile = NULL;
	}
}


int CTextFile::Seek( long offset, TEXTFILE_SEEK seekMode )
{
	int origin = SEEK_SET;

	ASSERT( m_pFile );

	switch( seekMode )
	{
		case seekBegin:   origin = SEEK_SET; break;
		case seekEnd:     origin = SEEK_END; break;
		case seekCurrent: origin = SEEK_CUR; break;
		default:
			ASSERT( FALSE );
	}

	return fseek( m_pFile, offset, origin );
}

int CTextFile::GetPosition()
{
	long offset = -1;

	ASSERT( m_pFile );

	return ftell( m_pFile );
}
