/*
** Copyright (C) 1999 - 2002 Albert L. Faber
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef UTIL_H_INCLUDED
#define UTIL_H_INCLUDED

#define ForceCloseHandle(x) if (x) { CloseHandle(x); x = NULL; }

#include "CDRip/CDRip.h"
#include "Language.h"

void InitUtil(void);
DOUBLE GetMyFreeDiskSpace(CString& strPath);
BOOL IsWindowsNTOS();

BOOL AsciiOnly( const CString& strToTest );

BOOL CheckNoFileOverwrite( CWnd* pWnd, CString strFileName, BOOL bAsk, BOOL& bYesToAll, BOOL& bNoToAll);

BOOL LoadDLL(	const CString& strDllName,
				const CString& strPath,
				HINSTANCE&		hDll,
				BOOL			bShowWarning,
				BOOL			bUnicodeDLL );

CDEX_ERR CalculateFileCrc32( const CString& strFileName, DWORD& dwCrc32 );

CString GetCDexAppPath();

INT QueryModuleDebugLevel( const CString& strModule );


extern CLanguage g_language;

BOOL UseFlatLookToolBar();

LPCSTR GetDosFileName( const CString& strPath );

#endif

