/*
Module : DDXGETFOLDER.CPP
Purpose: Defines the interface to a for a MFC DDX_ routine to get a directory/folder
         Using the file open/save as common dialogs
Created: PJN / 26-03-1997
History: None

Copyright (c) 1997 by PJ Naughter.  
All rights reserved.

*/


////////////////////////////////// Macros ///////////////////////////

#ifndef __DDXGETFOLDER_H__
#define __DDXGETFOLDER_H__


////////////////////////////////// Consts /////////////////////////////////////

//flags used to control how the DDX_GetFolderControl routine works

const DWORD GFLDR_OLD_STYLE_DIALOG = 0x0001;   //Use the old style file open dialog instead of the
                                               //style as used in Windows Explorer



////////////////////// foward declaration ///////////////////////////
class CGetFolderControl;


/////////////////////////// Classes /////////////////////////////////
class CModifyButton : public CButton
{
public:
  CModifyButton();
  void SetBuddy(CGetFolderControl* pBuddy);

protected:
  //{{AFX_VIRTUAL(CModifyButton)
  public:
  virtual BOOL PreTranslateMessage(MSG* pMsg);
  //}}AFX_VIRTUAL

  //{{AFX_MSG(CModifyButton)
  afx_msg void OnClicked();
  //}}AFX_MSG

  DECLARE_MESSAGE_MAP()

  CGetFolderControl* m_pBuddy;
  BOOL m_bFirstCall;
  CToolTipCtrl m_ToolTip;
};



class CGetFolderControl : public CStatic
{
public:
  CGetFolderControl();

  BOOL SubclassEdit(HWND hEdit);
  void SetFlags(DWORD dwFlags, const CString& sTitle);
  void Edit();

protected:
  //{{AFX_VIRTUAL(CGetFolderControl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

  //{{AFX_MSG(CGetFolderControl)
  //}}AFX_MSG

  DECLARE_MESSAGE_MAP()

  BOOL AddEditButton();

  CModifyButton m_Edit;
  DWORD         m_dwFlags;
  CString       m_sTitle;
};





/////////////// MFC Data exchange routines //////////////////////////

void DDX_GetFolderControl(CDataExchange* pDX, int nIDC, CGetFolderControl& rCGetFolderControl, DWORD dwFlags, const CString& sTitle);


#endif //_DDXGETFOLDER_H__