/* (c)Copyright 1996-2000 NTT Cyber Space Laboratories */
/*                Modified on 2000.09.06 by N. Iwakami */

// Chunk1.h: CChunk NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHUNK1_H__E059C7BF_6C3B_11D4_A71A_00C04F012175__INCLUDED_)
#define AFX_CHUNK1_H__E059C7BF_6C3B_11D4_A71A_00C04F012175__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <string>
#include <vector>

//////////////////////////////////////
//////////////////////////////////////
// CChunk NX̃C^tF[X
// CChunk NX̓`N̊{\񋟂B̃f[^o͂
class CChunk
{
public:
	typedef std::vector<char> CChunkData;

private:
	std::string m_id;
	CChunkData  m_data;
	CChunkData::iterator m_iter;

protected:
	int   GetNInt( int size=sizeof(long) );			// ݈ʒu size oCg擾iftHgFlongj
	CChunkData GetVector( int size = 0 );			// ݈ʒu size oCg̃xNg擾iftHgFcSj
	std::string GetRndString( int length = 0 );		// ݈ʒu length ̕擾iftHgFcSj

	void PutNInt( unsigned int inputData, int size=sizeof(long) );	// ݈ʒu size oCg݁iftHgFlongj

	void  cnk_rewind();								// ݈ʒu擪ɖ߂
	void cnk_delete();								// f[^
	const int   GetCurrentPosition()				// ݈ʒu擾
	{
		return m_iter - m_data.begin();
	};

	// O
	class err_FailPut { };

public:
	CChunk( std::string ID );	// RXgN^
	virtual ~CChunk();			// fXgN^

	// 擾no֐
	const std::string& GetID() { return m_id; };		// ID ̎擾
	const int GetSize() { return m_data.size(); };	// `NTCY̎擾
	const CChunkData& GetData() { return m_data; };

	// ݌no֐
	int PutData( int size, char inputData[] );		// f[^ǉALN^z^
	int PutData( CChunkData& inputData );			// f[^ǉAxNg^
	int PutData( std::string& theString );			// f[^ǉA^

	virtual std::string whatami() { return "Raw"; };

};


// CChunkChunk NX̃C^[tFCX
// ݂̂i[`NAėp`N^
//
//////////////////////////////////////////////////////////////////////
class CStringChunk : public CChunk  
{
public:
	std::string GetString() { cnk_rewind(); return GetRndString(); };
	CStringChunk( const CChunk& parent ) : CChunk( parent ) { };
	CStringChunk( std::string ID, std::string data="" ) : CChunk( ID ) { if ( data != "" ) PutData( data ); };
	virtual ~CStringChunk();

	std::string whatami() { return "String"; };
};


// CIntChunk ev[g
// Pi[`N^̃ev[gAėp`N^
//
//////////////////////////////////////////////////////////////////////
template <class TINT>
class CIntChunk : public CChunk  
{
	int m_dataSize;
public:
	const TINT GetInt() { cnk_rewind(); return GetNInt(m_dataSize); };	// f[^擾
	int PutInt( TINT data ) { cnk_delete(); PutNInt( data, m_dataSize ); };

	CIntChunk( const CChunk& parent ) : CChunk(parent) { m_dataSize = sizeof(TINT); };
	CIntChunk( std::string id, TINT data ) : CChunk(id) { 
		m_dataSize = sizeof(TINT);
		PutNInt( data, m_dataSize );
	}
	virtual ~CIntChunk() { };

	std::string whatami() { char retstr[20]; sprintf( retstr, "Integer, size=%d", m_dataSize ); return retstr; };
};


// CChunkChunk NX̃C^[tFCX
// `Ni[`NAėp`N^
//
//////////////////////////////////////////////////////////////////////
class CChunkChunk : public CChunk  
{
public:
	CChunk* GetNextChunk( int idSize = 4 );	// ̃`NԂ
	void rewind() { cnk_rewind(); };		// ߂
	void PutChunk( CChunk& src );

	CChunkChunk( const CChunk& parent ) : CChunk( parent ) { };	// RXgN^ECChunk IuWFNgɂ
	CChunkChunk( std::string ID ) : CChunk( ID ) { };		// RXgN^EID ^̃`N쐬
	virtual ~CChunkChunk();									// fXgN^

	// O
	class err_FailGetChunk { };		// `N擾Ɏs
	class err_FailPutChunk { };		// `N݂Ɏs

	std::string whatami() { return "Chunk"; };
};

// CCommChunk NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////
class CCommChunk : public CChunk  
{
public:
	typedef std::string string;
	typedef unsigned long CommData;

private:
	string m_version;
	CommData m_channelMode;
	CommData m_bitRate;
	CommData m_samplingRate;
	CommData m_securityLevel;

public:
	CCommChunk( const CChunk& parent, string version="TWIN97012000" );
	CCommChunk( CommData channelMode, CommData bitRate, CommData samplingRate, CommData securityLevel, string version="TWIN97012000" );
	virtual ~CCommChunk();

	CommData GetChannelMode()  { return m_channelMode;  };		// `l[h擾
	CommData GetBitRate()      { return m_bitRate;      };		// rbg[g擾
	CommData GetSamplingRate() { return m_samplingRate; };		// TvOg擾
	CommData GetSecurityLevel()  { return m_securityLevel;  };	// ǉ擾

	// O
	class err_FailConstruction { };							// G[FRXgNVɎs

	std::string whatami() { return "COMM"; };
};


// CYearChunk NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////
class CYearChunk : public CChunk  
{
	short m_year;
	char  m_month;

public:
	const short GetYear() { return m_year; };
	const char GetMonth() { return m_month; };

	CYearChunk( std::string id, short year, char month ) : CChunk( id ) {
		m_year = year;
		m_month = month;
		PutNInt ( m_year, sizeof(short) );
		PutNInt ( m_month, sizeof(char) );
	};
	CYearChunk( const CChunk& parent ) : CChunk( parent ) {
		cnk_rewind();
		m_year = GetNInt( sizeof(short) );
		m_month = GetNInt( sizeof(char) );
	};
	virtual ~CYearChunk() { };

	std::string whatami() { return "YEAR"; };
};

// CEncdChunk NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////
class CEncdChunk : public CChunk  
{
	short m_year;
	char  m_month;
	char  m_day;
	char  m_hour;
	char  m_minute;
	char  m_timeZone;

public:
	const short GetYear()     { return m_year; };
	const char  GetMonth()    { return m_month; };
	const char  GetDay()      { return m_day; };
	const char  GetHour()     { return m_hour; };
	const char  GetMinute()   { return m_minute; };
	const char  GetTimeZone() { return m_timeZone; };

	CEncdChunk( std::string id, short year, char month, char day, char hour, char minute, char timeZone );
	CEncdChunk( const CChunk& parent );
	virtual ~CEncdChunk();

	std::string whatami() { return "ENCD"; };
};



/////////////////////////////////////////////////////////
// ėp`N^𗘗pTu`N^̐錾
/////////////////////////////////////////////////////////
// TWIN `N
typedef CChunkChunk			CTwinChunk;	// TWIN

// W`N
										// COMM ͔ėp`Nł͂Ȃ
typedef CStringChunk		CNameChunk;	// NAME
typedef CStringChunk		CComtChunk;	// COMT
typedef CStringChunk		CAuthChunk;	// AUTH
typedef CStringChunk		CCpyrChunk;	// (c)
typedef CStringChunk		CFileChunk;	// FILE
typedef CIntChunk<unsigned long>	CDsizChunk;	// DSIZ
typedef CChunk				CExtrChunk;	// EXTR

// g`NEʏ
typedef CStringChunk		CAlbmChunk;	// ALBM
										// YEAR ͔ėp`Nł͂Ȃ
										// ENCD ͔ėp`Nł͂Ȃ
typedef CIntChunk<short>	CTracChunk;	// TRAC
typedef CStringChunk		CLyrcChunk;	// LYRC
typedef CChunk				CGuidChunk;	// GUID
typedef	CStringChunk		CIsrcChunk;	// ISRC
typedef	CStringChunk		CWordChunk;	// WORD
typedef CStringChunk		CMuscChunk;	// MUSC
typedef CStringChunk		CArngChunk;	// ARNG
typedef CStringChunk		CProdChunk;	// PROD
typedef CStringChunk		CRemxChunk;	// REMX
typedef CStringChunk		CCdctChunk;	// CDCT
typedef CStringChunk		CSingChunk;	// SING
typedef CStringChunk		CBandChunk;	// BAND
typedef CStringChunk		CPrsnChunk;	// PRSN
typedef CStringChunk		CLablChunk;	// LABL
typedef CStringChunk		CNoteChunk;	// NOTE

// g`NE⏕
typedef CChunkChunk			CScndChunk;	// SCND

// \`N
typedef CChunk				C_Id3Chunk;	// _ID3
typedef CChunk				C_YmhChunk;	// _YMH
typedef CChunk				C_NttChunk;	// _NTT


#endif // !defined(AFX_CHUNK1_H__E059C7BF_6C3B_11D4_A71A_00C04F012175__INCLUDED_)
