/* (c)Copyright 1996-2000 NTT Cyber Space Laboratories */
/*                Modified on 2000.09.06 by N. Iwakami */

// HeaderManager.h: CHeaderManager NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HEADERMANAGER_H__E059C7C4_6C3B_11D4_A71A_00C04F012175__INCLUDED_)
#define AFX_HEADERMANAGER_H__E059C7C4_6C3B_11D4_A71A_00C04F012175__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <map>
#include "Chunk.h"


class CHeaderManager  
{
public:
	typedef std::map<std::string, CChunk> CChunkBank;	// `NoN^AIDL[Ƀ`Ni[Ă}bv
	typedef std::string string;							// ^

private:
	// oϐiNXj
	CChunkBank m_primaryChunkBank;			// ʏ`Ñ`NoN
	CChunkBank m_secondaryChunkBank;		// ⏕`Ñ`NoN
	string     m_chunkID;					// TWIN `NIDAʏIDƈႢ "TWIN"+<o[Wʎq>ō\B

	// o֐
	CChunk GetChunk( CChunkBank *theBank, string id );						// `NoNIDŃ`No
	void PickUpSubChunks ( CChunkBank* theChunkBank, CChunkChunk *inputChunk );	// Chunk^̃`NTu`No`NoNɓo^
	void Init( CChunkChunk& twinChunk );	// BRXgN^̑Ɏg
	CHeaderManager() { };					// RXgN^B[U͌ĂׂȂB Create() gB
											// ̍ۂɃG[o\邽߂̂悤ȎdlɂB

	// NX̒ŎgO
	class err_WrongChunkFormat { };		// `N̏Ȃ

public:
	CChunk GetPrimaryChunk( string id )   { return GetChunk( &m_primaryChunkBank,   id ); }; // ʏ`No
	CChunk GetSecondaryChunk( string id ) { return GetChunk( &m_secondaryChunkBank, id ); }; // ⏕`No
	const string  GetID() { return m_chunkID; };

	static CHeaderManager* Create( CChunkChunk& twinChunk );	// `N}l[WoBRXgN^̑
	virtual ~CHeaderManager();	// fXgN^

	// O
	class err_FailGetChunk { };			// `N̎擾Ɏs

};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
// wb_}l[W̃f[^ǂݏo̎xNX
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

// CUniStringInfo NX̃C^[tFCX
// Unified string information, `N̑Awb_}l[W擾邱Ƃł
//
//////////////////////////////////////////////////////////////////////////////////////////////////
class CUniStringInfo
{
public:
	typedef std::string string;
	typedef std::string string;
	enum CharCode {
		unknown_code = -1,
		ISO_8859_1,
		Unicode,
		S_JIS,
		JIS,
		EUC,
	};
	
private:
	string m_id;				// `N ID
	string m_primary;			// {
	string m_secondary;			// ⏕
	int m_primaryCharCode;		// {̕R[h
	int m_secondaryCharCode;	// ⏕̕R[h

	void PutPrimaryInfo( CStringChunk& theChunk );
	void PutSecondaryInfo( CStringChunk& theChunk );

	// ŎgO
	class err_ID { };					// ̍ہA{`Nƕ⏕`N ID HĂ
	class err_NoCharCode { };			// ⏕`NɕR[h񂪂Ȃ

public:
	const string& GetPrimaryInfo() { return m_primary; };				// {Ԃ
	const string& GetSecondaryInfo() { return m_secondary; };			// ⏕Ԃ
	const int GetPrimaryCharCode() { return m_primaryCharCode; };		// {̕R[hԂ
	const int GetSecondaryCharCode() { return m_secondaryCharCode; };	// ⏕̕R[hԂ

	CUniStringInfo( string id, string primary, string secondary="", int primCode=unknown_code, int scndCode=unknown_code ); // RXgN^AKvȏSė^
	CUniStringInfo( string id, CHeaderManager& theManager );	// RXgN^Awb_}l[Wǂݏo
	virtual ~CUniStringInfo();

	// O
	class err_FailConstruction { };		// RXgNg̎s
};

template<class T>
T* GetPrimaryChunkFromHeaderManager( std::string id, CHeaderManager& theManager )
{

	try {
		CChunk src = theManager.GetPrimaryChunk(id);
		T* chunk = new T(src);
		return chunk;
	}
	catch ( CHeaderManager::err_FailGetChunk ) {
		return NULL;
	}
}

template<class T>
T* GetSecondaryChunkFromHeaderManager( std::string id, CHeaderManager& theManager )
{

	try {
		CChunk src = theManager.GetSecondaryChunk(id);
		T* chunk = new T(src);
		return chunk;
	}
	catch ( CHeaderManager::err_FailGetChunk ) {
		return NULL;
	}
}


#endif // !defined(AFX_HEADERMANAGER_H__E059C7C4_6C3B_11D4_A71A_00C04F012175__INCLUDED_)
