/* (c)Copyright 1996-2000 NTT Cyber Space Laboratories */
/*                Modified on 2000.09.06 by N. Iwakami */

#include "ChunkHelper.h"
#include <iostream>


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// wb_`N쐬̕⏕֐i`Nt@CTu`N쐬j
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// TRAC ^
static
int ReadTracChunk( FILE *fp, std::string id, CChunkChunk *theChunkChunk )
{
	// Kvȃf[^̓ǂݍ
	int trackNumber=0;
	fscanf( fp, "%d", &trackNumber );

	// Tu`N쐬Eǉ
	CTracChunk subChunk( id, trackNumber );
	theChunkChunk->PutChunk( subChunk );

	return 0;
}

// YEAR ^
static
int ReadYearChunk( FILE *fp, std::string id, CChunkChunk *theChunkChunk )
{
	// Kvȃf[^̓ǂݍ
	int year = 0;
	int month = 0;
	fscanf( fp, "%d %d", &year, &month );

	// Tu`N쐬Eǉ
	CYearChunk subChunk( id, year, month );
	theChunkChunk->PutChunk( subChunk );

	return 0;
}

// ENCD ^
static
int ReadEncdChunk( FILE *fp, std::string id, CChunkChunk *theChunkChunk )
{
	// Kvȃf[^̓ǂݍ
	int year=0, month=0, day=0, hour=0, minute=0, timeZone=0;
	fscanf( fp, "%d %d %d %d %d %d", &year, &month, &day, &hour, &minute, &timeZone );

	// Tu`N쐬Eǉ
	CEncdChunk subChunk( id, year, month, day, hour, minute, timeZone );
	theChunkChunk->PutChunk( subChunk );

	return 0;
}

// ėp^i^܂ށj
static
int ReadRawChunk( FILE *fp, std::string id, CChunkChunk *theChunkChunk ){
	// `N쐬
	CChunk subChunk( id );

	// Kvȃf[^̓ǂݍ
	char buf;
	while ( fread( &buf, 1, sizeof(char), fp ) ){
		subChunk.PutData( 1, &buf );
	}

	// Tu`Nǉ
	theChunkChunk->PutChunk( subChunk );

	return 0;
}



//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// `Nǂݍ݃e[u
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
#define ReadStringChunk ReadRawChunk

typedef struct {
	char* id;
	int (*reader)( FILE *fp, std::string id, CChunkChunk *theChunkChunk );
} CHUNK_READ_TABLE;

static CHUNK_READ_TABLE primaryReadTable[] = {
	{ "TRAC", ReadTracChunk },		// gbNԍ
	{ "YEAR", ReadYearChunk },		// ^ꂽN
	{ "ENCD", ReadEncdChunk },		// GR[h̓t
	{ "GUID", ReadRawChunk },		// Globally Unique Identifier
	{ "ISRC", ReadRawChunk },		// International Standard Record Code
	{ "ALBM", ReadStringChunk },	// Ao^Cg
	{ "LYRC", ReadStringChunk },	// ̎
	{ "WORD", ReadStringChunk },	// 쎌
	{ "MUSC", ReadStringChunk },	// Ȏ
	{ "ARNG", ReadStringChunk },	// ҋȎ
	{ "PROD", ReadStringChunk },	// vf[T[
	{ "REMX", ReadStringChunk },	// ~bNX
	{ "CDCT", ReadStringChunk },	// w
	{ "SING", ReadStringChunk },	// ̎
	{ "LABL", ReadStringChunk },	// [x
	{ "NOTE", ReadStringChunk },	// Ci[m[c
	{ "PRSN", ReadStringChunk },	// to[
	{ "BAND", ReadStringChunk },	// oh
	{ NULL },
};

static CHUNK_READ_TABLE secondaryReadTable[] = {
	{ "NAME", ReadStringChunk },	// Ȗ
	{ "AUTH", ReadStringChunk },	// A[eBXg
	{ "COMT", ReadStringChunk },	// Rg
	{ "(c) ", ReadStringChunk },	// 쌠

	{ "ALBM", ReadStringChunk },	// Ao^Cg
	{ "LYRC", ReadStringChunk },	// ̎
	{ "WORD", ReadStringChunk },	// 쎌
	{ "MUSC", ReadStringChunk },	// Ȏ
	{ "ARNG", ReadStringChunk },	// ҋȎ
	{ "PROD", ReadStringChunk },	// vf[T[
	{ "REMX", ReadStringChunk },	// ~bNX
	{ "CDCT", ReadStringChunk },	// w
	{ "SING", ReadStringChunk },	// ̎
	{ "LABL", ReadStringChunk },	// [x
	{ "NOTE", ReadStringChunk },	// Ci[m[c
	{ "PRSN", ReadStringChunk },	// to[
	{ "BAND", ReadStringChunk },	// oh
	{ NULL },
};

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// wb_`N쐬֐
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
/*----------------------------------------------------------------------------*/
/* Name:        PutTextChunk()                                                */
/* Description: `N쐬 TWIN `Nɕt            */
/* Return:      Ȃ                                                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
void PutTextChunk( char* id, char* theData, CChunkChunk* twinChunk ) {
	if ( strlen( theData ) ) {
		CStringChunk theStringChunk( id, theData );
		twinChunk->PutChunk( theStringChunk );
	}
}

/*----------------------------------------------------------------------------*/
/* Name:        PutStandardChunks()                                           */
/* Description: TWIN `NɕW`Nt                       */
/* Return:      (int) G[΂PAȂ΂O                            */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int PutStandardChunks( headerInfo* info, CChunkChunk* twinChunk )
{
	// COMM `N쐬 TWIN `Nɕt
	std::string version = twinChunk->GetID();
	CCommChunk theCommChunk( info->channelMode, info->bitRate, info->samplingRate, info->securityLevel );
	twinChunk->PutChunk( theCommChunk );

	// W`N쐬 TWIN `Nɕt
	PutTextChunk( "NAME", info->Name, twinChunk );
	PutTextChunk( "COMT", info->Comt, twinChunk );
	PutTextChunk( "AUTH", info->Auth, twinChunk );
	PutTextChunk( "(c) ", info->Cpyr, twinChunk );
	PutTextChunk( "FILE", info->File, twinChunk );

	// f[^TCY`N쐬ĕt
	if ( info->Dsiz > 0 ) {
		CDsizChunk dsizChunk( "DSIZ", info->Dsiz );
		twinChunk->PutChunk( dsizChunk );
	}

	return 0;
}

/*----------------------------------------------------------------------------*/
/* Name:        PutChunkInfo()                                                */
/* Description: `Nt@Cǂݍ twin `Nɒǉ    */
/* Return:      (int) G[΂PAȂ΂O                            */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int PutChunkInfo ( CHUNK_READ_TABLE theTable[], CChunkChunk *twinChunk, int mode, std::string directory )
{
	std::string infoDir[] = { "/", "/SCND/" };

	if ( mode >= 2 ) return 1;

	while ( theTable->id ) {
		/* t@C */
		std::string fileName = theTable->id;
		std::string pathName = directory + infoDir[mode] + fileName;
		
		/* t@C`FbNAt@CΏ荞 */
		FILE *fp;
		if ( (fp=fopen(pathName.c_str(), "rb")) ) {
			(*theTable->reader)( fp, theTable->id, twinChunk );
			fclose ( fp );
		}
		++theTable;
	}

	return 0;
}

/*============================================================================*/
/* Name:        TvqCreateHeaderChunk()                                        */
/* Description: wb_`N쐬B                                    */
/* Return:      wb_`NB쐬Ɏsꍇ NULL ߂                */
/* Access:      external                                                      */
/*============================================================================*/
CChunkChunk* TvqCreateHeaderChunk( headerInfo* setupInfo, std::string directory )
{
	/* Create empty "TWIN" chunk */
	CChunkChunk* twinChunk = new CChunkChunk( setupInfo->ID );

	/* Put standard chunks in the "TWIN" chunk */
	if ( PutStandardChunks( setupInfo, twinChunk ) ) return NULL;

	/* Put extended chunks (primary) in the "TWIN" chunk */
	if ( PutChunkInfo( primaryReadTable, twinChunk, PRIMARY, directory ) ) return NULL;

	/* Put extended chunks (secondary) in the "TWIN" chunk */
	{
		CChunkChunk scndChunk( "SCND" );
		if ( PutChunkInfo( secondaryReadTable, &scndChunk, SECONDARY, directory ) ) return NULL;
		if ( scndChunk.GetSize() ) {
			twinChunk->PutChunk( scndChunk );
		}
	}

	return twinChunk;
}
