/* (c)Copyright 1996-2000 NTT Cyber Space Laboratories */
/*                Released on 2000.09.06 by N. Iwakami */
/*                Modified on 2000.09.22 by N. Iwakami */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include "twinvq.h"
#include "bfile.h"
#include "bstream_e.h"
#include "tvqenc.h"
#include "ChunkHelper.h"

/*----------------------------------------------------------------------------*/
/* `                                                                       */
/*----------------------------------------------------------------------------*/
#define YES 1
#define NO  0

#define min(x, y) ( (x) < (y) ? (x) : (y) )
#define DISP_FRAME   YES		 /* YES: GR[his\ */
#define INIT_ERR_DISP_MBOX  YES  /* YES: G[ɁAGR[_ DLL G[bZ[W{bNXo */

#define TEST_PROGRAM_VERSION "2.3.0.02 (open version), API-C, HD2.0"
#define COPYRIGHT            "Copyright (C) 1996-2000 NTT Cyber Space Laboratories."

#if defined (_MSC_VER)
#  define stat _stat
#endif

/* WAVE t@C̃wb_ */
static const int WAVE_ID_SIZE = 4;
typedef struct {
	char  riffID[WAVE_ID_SIZE+1];
	long  riffSize;
	char  waveID[WAVE_ID_SIZE+1];
	char  fmt_ID[WAVE_ID_SIZE+1];
	long  fmt_Size;
	short format;
	short numChannels;
	long  samplingRate;
	long  byteRate;
	short blockSize;
	short numBitsPerSample;
	char  dataID[WAVE_ID_SIZE+1];
	long  dataSize;
} WAVE_HEADER;

/*----------------------------------------------------------------------------*/
/* ÓIϐ                                                                   */
/*----------------------------------------------------------------------------*/
static char *error_message[] = {   // G[bZ[We[uiG[R[hƑΉj
	"no error",
	"an error",
	"wrong version",
	"wrong channel mode",
	"unsupported coding mode",
	"inner parameter setting error.  Check bitrate",
	"wrong number of VQ pre-selection candidates",
};

// t@C^Cv֘A̒`
static enum {
	fileTypeWav = 0,
	fileTypeRaw,
} fileTypeNumber;

static char *fileTypeName[] = {	// t@C^CvAfileType tOƘAĂB
	"wav",
	"raw",
	NULL
};


/**********************************/
/**** pX^eBbN֐ ****/
/**********************************/

/*----------------------------------------------------------------------------*/
/* Name:        usage()                                                       */
/* Description: vO̎gp@\B                              */
/* Return:      Ȃ                                                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
void usage (char *p)
{
	fprintf(stderr, "Usage: %s [<options>] infile outfile\n\n", p);
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "    -c <#>\t: CH_MODE<0,1>\t\t(default=1 (stereo))\n");
	fprintf(stderr, "    -f <#>\t: ISAMPF<8,..,22,44>\t(default=44)\n");
	fprintf(stderr, "    -b <#>\t: IBPS<8,10,..,80,96>\t(default=96)\n");
	fprintf(stderr, "    -n <#>\t: N_CAN\t\t\t(default=16)\n");
	//    fprintf(stderr, "    -s\t\t: set enable to save vqf\t(default=no)\n");
	fprintf(stderr, "    -T <string>\t: title string\t\t(default=none)\n");
	fprintf(stderr, "    -C <string>\t: comment string\t(default=none)\n");
	fprintf(stderr, "    -A <string>\t: author string\t(default=\"\")\n");
	fprintf(stderr, "    -R <string>\t: copyright information string\t(default=\"\")\n");
	fprintf(stderr, "    -h <string>\t: directory for header info files (default=\"header_info\")\n" );
	fprintf(stderr, "    --version: print program version\n" );
	return;
}


/*----------------------------------------------------------------------------*/
/* Name:        SetDefault()                                                  */
/* Description: TwinVQ ZbgAbṽftHglݒ                   */
/* Return:      none                                                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
void SetDefault( headerInfo *setupInfo, encSpecificInfo *encInfo, int *fileType, char *headerInfoDir )
{
	TvqGetVersionID( V2, setupInfo->ID );  // ftHg̃o[W Ver.2 ɂ
	setupInfo->channelMode = 1;		// `lFXeI
	setupInfo->samplingRate = 44;   // TvOgF 44.1 khz
	setupInfo->bitRate = 96;       // rbg[gF96 kbit/s
	strcpy(setupInfo->Name, "");    // wb_⏕
	strcpy(setupInfo->Comt, "");
	strcpy(setupInfo->Auth, "");
	strcpy(setupInfo->Cpyr, "");
	strcpy(setupInfo->File, "");
	setupInfo->Dsiz = 0;
	setupInfo->securityLevel = 0;
	
	encInfo->N_CAN_GLOBAL = 16;      // VQ ̗\I𐔁F16

	*fileType = fileTypeWav;		// ftHg̃t@C^Cv

	sprintf( headerInfoDir, "header_info" );	// wb_i[fBNg
}

/*--------------------------------------------------------------------------------------------*/
/* Name:        CheckWaveChunkHeader()                                                        */
/* Description: WAVE f[^t@C̃`NID ǂݍ݃`FbN                        */
/* Return:      (int) ǂݍIDQIDƓȂ0, Ε̐A傫ΐ̐ */
/* Access:      static                                                                        */
/*--------------------------------------------------------------------------------------------*/
static
int CheckWaveChunkHeader( char* ID, char* refID, FILE *fp )
{
	fread( ID, WAVE_ID_SIZE, sizeof(char), fp );
	ID[WAVE_ID_SIZE] = '\0';
	return strcmp( ID, refID );
}

/*----------------------------------------------------------------------------*/
/* Name:        ReadWaveHeader()                                              */
/* Description: WAVE f[^t@C̃wb_ǂݍށB                       */
/* Return:      (int) G[΂PAȂ΂O                            */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int ReadWaveHeader( WAVE_HEADER* waveHeader, FILE* fp_i )
{
	/* read and check "RIFF" header */
	if ( CheckWaveChunkHeader( waveHeader->riffID, "RIFF", fp_i ) ) {
		fprintf( stderr, "Error: Not a RIFF format file.\n" );
		return 1;
	}
	fread( &waveHeader->riffSize, 1, sizeof(long), fp_i ); // RIFF chunk size
	
	/* read and check "WAVE" header */
	if( CheckWaveChunkHeader( waveHeader->waveID, "WAVE", fp_i ) ){
		fprintf(stderr, "%s: Error: Not a WAVE format file.\n", waveHeader->waveID);
		return 1;
	}

	/* read and check "fmt " header */
	if ( CheckWaveChunkHeader( waveHeader->fmt_ID, "fmt ", fp_i ) ) {
		fprintf( stderr, "Error: \"fmt \" chunk not found in wave file format.\n" );
		return 1;
	}
	fread( &waveHeader->fmt_Size, 1, sizeof(long), fp_i ); // fmt chunk size

	// read data of "fmt " header
	fread( &waveHeader->format, 1, sizeof(short), fp_i );			// data type
	fread( &waveHeader->numChannels, 1, sizeof(short), fp_i );		// number of channels
	fread( &waveHeader->samplingRate, 1, sizeof(long), fp_i );		// sampling frequency
	fread( &waveHeader->byteRate, 1, sizeof(long), fp_i );			// number of bytes per second
	fread( &waveHeader->blockSize, 1, sizeof(short), fp_i );		// block size
	fread( &waveHeader->numBitsPerSample, 1, sizeof(short), fp_i );	// number of bits per sample
	
	/* detect data chunk */
	int readIdSize;
	waveHeader->dataID[WAVE_ID_SIZE] = '\0';
	do {
		readIdSize = fread( waveHeader->dataID, WAVE_ID_SIZE, sizeof(char), fp_i );
		fread( &waveHeader->dataSize, 1, sizeof(long), fp_i );
	} while ( readIdSize == WAVE_ID_SIZE && strcmp( waveHeader->dataID, "data" ) );
	if ( strcmp(waveHeader->dataID, "data") ) {
		fprintf( stderr, "Error: data chunk not found in WAVE file.\n" );
		return 1;
	}

	return 0;
}

/*----------------------------------------------------------------------------*/
/* Name:        InitAudioFile()                                               */
/* Description: I[fBIt@CAKvȃp[^擾      */
/* Return:      (int) G[΂PAȂ΂O                            */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int InitAudioFile( char *namein, FILE **fp_i, int *data_size, int fileType, int *channelMode, int *samplingRate )
{
	WAVE_HEADER waveHeader;

	if ( (*fp_i=fopen(namein,"rb")) == NULL ){    // ̓t@CI[v
		fprintf( stderr, "%s: File not found\n", namein );
		return 1;
	}

	/* read header of wave format file */
	if( fileType == fileTypeWav ){ 
		// read header info
		if ( ReadWaveHeader( &waveHeader, *fp_i ) ) return 1;

		// check "fmt " info
		if ( waveHeader.format != 1 ) { // not a PCM file
			fprintf( stderr, "Error: unsupported WAVE data format.\n" );
			return 1;
		}
		if ( waveHeader.numBitsPerSample != 8 * sizeof(short) ) {	// not 16 bit integer
			fprintf( stderr, "Error: unsupported WAVE data format.\n" );
		}

		// get neccessary parameters
		*channelMode = waveHeader.numChannels - 1;			// number of channels (override)
		*samplingRate = waveHeader.samplingRate / 1000;		// sampling rate (override)
		*data_size = waveHeader.dataSize / sizeof(short);	// audio data size

	} /* if( fileType == fileTypeWav ) */
	else{ /* raw file format */
		struct stat buffer;
		stat( namein, &buffer );
		*data_size = buffer.st_size / sizeof(short);
	}

	return 0;
}


/*----------------------------------------------------------------------------*/
/* Name:        ReceiveArguments()                                            */
/* Description: 擾                                                    */
/* Return:      (int) G[ 1, Ȃ 0                            */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static int check_iarg( int iarg, int argc, char *comname )
{
	if ( iarg >= argc ) {
		usage( comname );
		return 1;
	}
	return 0;
}
static
int ReceiveArguments(int argc, char *argv[],
					 headerInfo *setupInfo,
					 encSpecificInfo *encInfo,
					 char **namein,
					 char **nameout,
					 FILE **fp_i,
					 int *fileType,
					 int *data_size,
					 char *headerInfoDir)
{
	int iarg=0;

	// ̐`FbN
	if ( argc < 3 ) {
		if ( check_iarg( ++iarg, argc, argv[0]) ) return 1;
		if ( ! strcmp( argv[iarg], "--version" ) ) {
			char module_version[256];
			TvqEncGetModuleVersion( module_version );
			printf("TwinVQ test encoder version %s,\n", TEST_PROGRAM_VERSION );
			printf("using TwinVQ encoder module version %s.\n", module_version );
			printf("\n%s\n", COPYRIGHT );
		}
		return 1;
	}

	// o̓t@C擾
	*namein  = argv[argc-2];
	*nameout = argv[argc-1];

	// ̓t@C̊gq𒲂׃ftHg̃t@C^Cvݒ肷B
	int ichar = 0;
	char* strTmp = *namein;
	for ( ichar=strlen(strTmp); ichar>0 && strTmp[ichar-1] != '.'; ichar-- );
	if ( ! strcmp( &strTmp[ichar], "wav" ) || ! strcmp( &strTmp[ichar], "WAV" ) ) {
		*fileType = fileTypeWav;
	}
	else {
		*fileType = fileTypeRaw;
	}

	// ̓t@CKvȃp[^擾B
	if ( InitAudioFile( *namein, fp_i, data_size, *fileType, &setupInfo->channelMode, &setupInfo->samplingRate ) ) {
		fprintf( stderr, "Error in opening audio file.\n" );
		return TVQ_ERROR;
	}

	// IvV̓ǂݍ
	while( ++iarg < argc && argv[iarg][0]=='-' ){
		switch ( argv[iarg][1] ){
		case 'c': // channel mode
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			if ( (setupInfo->channelMode=atoi(argv[iarg]) ) < 0) {
				fprintf(stderr, "Error: CH_MODE(%d)\n", setupInfo->channelMode);
				return 1;
			}
			break;
		case 'f': // sampling frequency mode
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			if ((setupInfo->samplingRate=atoi(argv[iarg])) < 0) {
				fprintf(stderr, "Error: ISAMPF(%d)\n", setupInfo->samplingRate);
				return 1;
			}
			break;
		case 'b':  // bitrate
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			if ((setupInfo->bitRate=atoi(argv[iarg])) < 0) {
				fprintf(stderr, "Error: IBPS(%d)\n", setupInfo->bitRate);
				return 1;
			}
			break;
		case 'n':  // number of conjugate VQ candidates
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			if ((encInfo->N_CAN_GLOBAL=atoi(argv[iarg])) < 0) {
				fprintf(stderr, "Error: N_CAN_GLOBAL(%d)\n", encInfo->N_CAN_GLOBAL);
				return 1;
			}
			break;
			//		case 's':  // save flag
			//			save_flag++;
			//			strcpy(setupInfo->File, nameout);
			//			break;
		case 'T':  // title
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			sprintf( setupInfo->Name, "%s", argv[iarg] );
			break;
		case 'C':  // comment
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			sprintf( setupInfo->Comt, "%s", argv[iarg] );
			break;
		case 'A':
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			sprintf( setupInfo->Auth, "%s", argv[iarg] );
			break;
		case 'R':
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			sprintf( setupInfo->Cpyr, "%s", argv[iarg] );
			break;
		case 't':
			if( check_iarg(++iarg, argc, argv[0]) ) return 1;
			{
				int itype;
				for ( itype=0; fileTypeName[itype]; itype++ ) {
					if( strcmp(argv[iarg], fileTypeName[itype]) == 0 ){
						*fileType = itype;
					}
					break;
				}
				if ( fileTypeName[itype] == NULL ) {
					usage( argv[0] );
					return 1;
				}
			}
			break;
		case 'h':
			if ( check_iarg(++iarg, argc, argv[0]) ) return 1;
			sprintf( headerInfoDir, "%s", argv[iarg] );
			break;
		default:
			usage(argv[0]);
			return 1;
			break;
		}
	}
	
	return 0;
}

/*----------------------------------------------------------------------------*/
/* Name:        InitializeProgram()                                           */
/* Description: vO                                            */
/* Return:      (int) G[ 1, Ȃ 0                            */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int InitializeProgram(int   argc,      // Input: number of arguments
					  char  *argv[],   // Input: the arguments
					  headerInfo      *setupInfo,  // Output: setup parameters
					  encSpecificInfo *encInfo,    // Output: encoder specific setup parameters
					  char  **namein,			// Output: input file name
					  FILE  **fp_i,
					  int   *fileType,
					  int   *data_size,
					  char  **nameout,
					  char  *headerInfoDir)
{
	/*--- ZbgAbṽftHglݒ ---*/
	SetDefault( setupInfo, encInfo, fileType, headerInfoDir );

	/*--- 擾EZbgAbvƓo̓t@C擾 ---*/
	if ( ReceiveArguments(argc, argv, setupInfo, encInfo, namein, nameout, fp_i, fileType, data_size, headerInfoDir) ){
		return 1;
	}
	
	return 0;
}
	
/*----------------------------------------------------------------------------*/
/* Name:        message()                                                     */
/* Description: p[^\B                                  */
/* Return:      Ȃ                                                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
void message(char	*namein,
	     char    *nameout,
	     char    *title,
	     char    *comment,
		 int     fileType)
{
	headerInfo hd;
	TvqEncGetSetupInfo(&hd);

	int numChannels = TvqEncGetNumChannels();
	float samplingRate = TvqEncGetSamplingRate();
	int bitRate = TvqEncGetBitRate();
	int NBITS_FR = TvqEncGetNumFixedBitsPerFrame();

    fprintf( stderr, "\n<<>><<>> TwinVQ encoder DLL test program <<>><<>>\n" );
    fprintf( stderr, "\n" );
		fprintf(stderr, "### Version: %s\n", hd.ID);
    fprintf( stderr, "### Input data file name:          %s\n", namein );
    fprintf( stderr, "### Output data file name:         %s\n", nameout );
	fprintf( stderr, "### Input audio data file type:    %s\n", fileTypeName[fileType] );
//    fprintf( stderr, "### Title:   %s\n", title );
//    fprintf( stderr, "### Comment: %s\n", comment );

    fprintf( stderr, "\n" );
    fprintf( stderr, "### Sampling frequency:    %8.1f kHz\n", samplingRate/1000.);
    fprintf( stderr, "### Total Bitrate (fixed part):         %8.1f kbit/s\n",
	    (float)bitRate );
    fprintf( stderr, "### Number of channels:         %d\n", numChannels );

//    fprintf( stderr, "### Num of Bits per frame:  %5d\n", NBITS_FR );

	fprintf(stderr, "\n");

}

/*----------------------------------------------------------------------------*/
/* Name:        InitializeEncoder()                                           */
/* Description: GR[_                                            */
/* Return:      G[R[h (twinvq.h )                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int InitializeEncoder(headerInfo *setupInfo,
					  encSpecificInfo *encInfo,
					  int *frameSize,
					  int *numChannels,
					  INDEX *index,
					  float **in,
					  short **bufin,
					  BFILE **bfp_cw,
					  char  *namein,
					  char  *nameout,
					  int   fileType,
					  char  *headerInfoDir)
{
	int errorCode;

	/*--- XebvPFTwinVQ GR[_ DLL W[ ---*/
	if ( errorCode = TvqEncInitialize( setupInfo, encInfo, index, INIT_ERR_DISP_MBOX ) ) return errorCode;

	/*--- XebvQFrbgXg[݃W[ ---*/
	if ( (*bfp_cw=bopen(nameout,"wb")) == NULL ){ // o̓rbgXg[t@CI[v
		fprintf( stderr, "%s: File open error.\n", nameout );
		return TVQ_ERROR;
	}
	TvqInitBsWriter(); // W[̏

	/*--- XebvRFI[fBIf[^͕ ---*/
	*frameSize = TvqEncGetFrameSize();				// I[fBIf[^obt@
	*numChannels = TvqEncGetNumChannels();
	*in    = new float[ *frameSize * *numChannels ];
	*bufin = new short[ *frameSize * *numChannels ];

	/*--- XebvSFrbgXg[wb_IuWFNg쐬 ---*/
	CChunkChunk* twinChunk = TvqCreateHeaderChunk( setupInfo, headerInfoDir );
	if ( twinChunk == NULL ) return TVQ_ERROR;

	/*--- XebvTFrbgXg[wb_ ---*/
	TvqPutBsHeaderInfo( *bfp_cw, *twinChunk );
	delete twinChunk;	// wb_݂̏Iwb_`N͏
	
	/*--- ZbgAbv\ ---*/
	message( namein, nameout, setupInfo->Name, setupInfo->Comt, fileType );

	return TVQ_NO_ERROR;
}

/******************************************/
/**** GR[hpX^eBbN֐ ****/
/******************************************/
/*----------------------------------------------------------------------------*/
/* Name:        buftofr()                                                     */
/* Description: ̓I[fBIt@Cf[^̃obt@`ϊ              */
/* Return:      Ȃ                                                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
void buftofr(int    blen,      /* Input  --- read data length */
			 short  bufin[],   /* Input  --- input data buffer array */
			 float in[],      /* Output --- output data frame */
			 int	frameSize,
			 int	numChannels)
{
	/*--- Variables ---*/
	int	ismp, ich, blen_ch;
	
	/*--- Initialization ---*/
	blen_ch = blen/numChannels;
	/*--- Main operation ---*/
	for ( ich=0; ich<numChannels; ich++ ){
		for ( ismp=0; ismp<blen_ch; ismp++ ){
			in[ich*frameSize+ismp] = (float)bufin[ismp*numChannels+ich];
		}
		for (ismp=blen_ch; ismp<frameSize; ismp++){
			in[ich*frameSize+ismp] = 0.;
		}
	}
}

/*----------------------------------------------------------------------------*/
/* Name:        mark()                                                        */
/* Description: GR[h̐is󋵂\B                              */
/* Return:      Ȃ                                                          */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
void mark(int ndata)
{
	fprintf(stderr, "Frame %6d      \r", ndata);
}


/*----------------------------------------------------------------------------*/
/* Name:        EncodingProcess()                                             */
/* Description: GR[h                                                */
/* Return:      G[ 1 Ȃ 0                                   */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int EncodingProcess(int   frameSize,   // t[TCY
					int   numChannels, // `l
					INDEX *index,      // R[hf[^󂯓np\
					float in[],        //  PCM t@Cpobt@
					short bufin[],     // DLL ͗pobt@
					FILE  *fp_i,       // ̓t@C|C^
					BFILE *bfp_cw,     // o̓rbgXg[t@C|C^
					int data_size)
{
	int blen;
	int iframe;
	int restSize, numFrames, totalFrameSize;

	totalFrameSize = frameSize * numChannels;
	numFrames      = data_size / totalFrameSize;
	restSize       = data_size % totalFrameSize;

	for( iframe = 0; iframe<numFrames+3; iframe++ ){
		/*--- t@CI[fBIf[^ǂݍ ---*/
		int readLength;
		if ( iframe < numFrames )		readLength = totalFrameSize;
		else if ( iframe == numFrames )	readLength = restSize;
		else							readLength = 0;
		blen = fread( bufin, sizeof(*bufin), readLength, fp_i );

		/*--- I[fBIf[^̓t[ւ̕ϊ ---*/
		buftofr( blen, bufin, in, frameSize, numChannels );
		/*-- GR[h --*/
		TvqEncodeFrame( in, index );
		
		/*-- rbgXg[ --*/
		TvqWriteBsFrame( index, bfp_cw );
		
		/*--- GR[his̕\ ---*/
#if DISP_FRAME
		mark( iframe );
#endif
		
	}

	fprintf( stderr, "\n" );
	return 0;
}

/************************************/
/**** IpX^eBbN֐ ****/
/************************************/
/*----------------------------------------------------------------------------*/
/* Name:        TerminateEncoder()                                            */
/* Description: TwinVQ GR[_̏I                                   */
/* Return:      G[ 1 Ȃ 0                                   */
/* Access:      static                                                        */
/*----------------------------------------------------------------------------*/
static
int TerminateEncoder( INDEX *index, float *in, short *bufin, FILE* fp_i, BFILE *bfp_cw ){

	TvqEncTerminate( index );
	delete[] in;
	delete[] bufin;
	fclose( fp_i );
	bclose( bfp_cw );

	return 0;
}

/****************************/
/******** C֐ ********/
/****************************/
/*============================================================================*/
/* Name:        main()                                                        */
/* Description: the main program                                              */
/* Return:      returns 1 when error or 0                                     */
/* Access:      external                                                      */
/*============================================================================*/
int main(int  argc,
		 char *argv[])
{

	/*--- vOs̏ ---*/
	char    *namein, *nameout;  // o̓t@C
	FILE	*fp_i;              // ̓I[fBIf[^t@C|C^
	BFILE	*bfp_cw;            // o̓rbgXg[t@C|C^
	headerInfo      setupInfo;  // TwinVQ ZbgAbv
	encSpecificInfo encInfo;    // GR[_L TwinVQ ZbgAbv
	int fileType;				// t@C^Cv
	int data_size;				// I[fBIf[^̃TCY
	char headerInfoDir[BUFSIZ];

	if ( InitializeProgram( argc, argv, &setupInfo, &encInfo, &namein, &fp_i, &fileType, &data_size, &nameout, headerInfoDir ) ){
		return 1;
	}

	/*--- TwinVQ GR[_ ---*/
	int frameSize, numChannels; // t[TCYƃ`l
	float *in;                  // DLL pf[^obt@
	short *bufin;               // PCM t@Cpf[^obt@
	INDEX index;                // R[hf[^󂯓np\
	int   errorCode;            // G[R[h

	if ( errorCode = InitializeEncoder(&setupInfo, &encInfo, &frameSize, &numChannels, &index, &in, &bufin, &bfp_cw, namein, nameout, fileType, headerInfoDir ) ){
		fprintf( stderr, "Initialization failed due to %s.\n", error_message[errorCode] );
		return 1;
	}

	/*--- GR[h ---*/
	if ( EncodingProcess( frameSize, numChannels, &index, in, bufin, fp_i, bfp_cw, data_size ) ){
		return 1;
	}
	
	/*--- I ---*/
	TerminateEncoder( &index, in, bufin, fp_i, bfp_cw );
	
	return 0;
}


