<?php
/**
 * @package modx
 */
require_once MODX_CORE_PATH . 'model/modx/xmlrpc/modxmlrpcresponse.class.php';
require_once MODX_CORE_PATH . 'model/modx/jsonrpc/jsonrpc.inc';
require_once MODX_CORE_PATH . 'model/modx/jsonrpc/jsonrpcs.inc';

/**
 * Extends modXMLRPCResponse to support servicing JSON-RPC client requests.
 *
 * @package modx
 * @subpackage jsonrpc
 */
class modJSONRPCResponse extends modXMLRPCResponse {
    public function outputContent(array $options= array()) {
        if (empty($options['rpc_type'])) $options['rpc_type']= 'JSON';
        parent :: outputContent($options);
    }

    public function getServer($execute= false) {
        if ($this->server === null || !($this->server instanceof jsonrpc_server)) {
            $this->server= new jsonrpc_server($this->services, $execute);
        }
        return $this->server instanceof jsonrpc_server;
    }
}