<?php
/**
 * Setting Dutch lexicon topic
 *
 * @language en
 * @package modx
 * @subpackage lexicon
 *
 * @author Bert Oost, <bertoost85@gmail.com>
 */
$_lang['area'] = 'Gebied';
$_lang['area_authentication'] = 'Authenticatie en beveiliging';
$_lang['area_caching'] = 'Caching';
$_lang['area_editor'] = 'Rich-Tekst Editor';
$_lang['area_file'] = 'Bestandssysteem';
$_lang['area_filter'] = 'Filter op gebied...';
$_lang['area_furls'] = 'Vriendelijke URLs';
$_lang['area_gateway'] = 'Gateway';
$_lang['area_language'] = 'Lexicon en taal';
$_lang['area_mail'] = 'Mail';
$_lang['area_manager'] = 'Back-end Manager';
$_lang['area_proxy'] = 'Proxy';
$_lang['area_session'] = 'Session en Cookie';
$_lang['area_lexicon_string'] = 'Gebied Lexicon Entry';
$_lang['area_lexicon_string_msg'] = 'Vul hier een sleutel in van de lexicon entry for het gebied. Indien er geen lexicon entry is, dan wordt de sleutel van het gebied getoond.<br />Core gebieden:<ul><li>authenticatie</li><li>caching</li><li>bestand</li><li>furls</li><li>gateway</li><li>taal</li><li>manager</li><li>session</li><li>site</li><li>systeem</li></ul>';
$_lang['area_site'] = 'Site';
$_lang['area_system'] = 'Systeem en Server';
$_lang['areas'] = 'Gebieden';
$_lang['namespace'] = 'Namespace';
$_lang['namespace_filter'] = 'Filter op namespace...';
$_lang['search_by_key'] = 'Zoek op sleutel...';
$_lang['setting_create'] = 'Maak nieuwe instelling';
$_lang['setting_err'] = 'Controleer jouw gegevens voor de volgende velden: ';
$_lang['setting_err_ae'] = 'Instelling met deze sleutel bestaat reeds. Definieer een andere sleutelnaam.';
$_lang['setting_err_nf'] = 'Instelling niet gevonden.';
$_lang['setting_err_ns'] = 'Instelling niet gedefinieerd';
$_lang['setting_err_remove'] = 'Er is een fout opgetreden tijdens het proberen te verwijderen van de instelling.';
$_lang['setting_err_save'] = 'Er is een fout opgetreden tijdens het proberen op te slaan van de instelling.';
$_lang['setting_err_startint'] = 'Instelling mag niet starten met een cijfer.';
$_lang['setting_err_invalid_document'] = 'Er is geen document met ID %d. Definieer een geldig document.';
$_lang['setting_remove'] = 'Instelling verwijderen';
$_lang['setting_remove_confirm'] = 'Weet je zeker dat je deze insteling wilt verwijderen? Dit kan jouw MODx installatie kapot maken.';
$_lang['setting_update'] = 'Instelling updaten';
$_lang['settings_after_install'] = 'Aangezien dit een nieuwe installatie is, ben je verplicht deze instellingen te controleren en daar waar je wenst aan te passen. Nadat je deze instellingen hebt gecontroleerd, klik op \'opslaan\' om de instellingen in de database weg te schrijven.<br /><br />';
$_lang['settings_desc'] = 'Hier kun je algemene instellingen en configuratie instellingen voor MODx manager interface instellen, en tevens voor jouw MODx website. Klik dubbel op de kolom met de waarde om de instelling welke je wilt aanpassen te wijzigen of klik met de rechtermuisknop op een instelling voor meer opties. Je kunt ook op het "+" teken klikken voor een omschrijving van de instelling.';
$_lang['settings_furls'] = 'Vriendelijke URLs';
$_lang['settings_misc'] = 'Diversen';
$_lang['settings_site'] = 'Site';
$_lang['settings_ui'] = 'Interface &amp; Features';
$_lang['settings_users'] = 'Gebruiker';
$_lang['system_settings'] = 'Systeeminstellingen';

// user settings
$_lang['setting_allow_mgr_access'] = 'Manager Interface Toegang';
$_lang['setting_allow_mgr_access_desc'] = 'Selecteer deze optie om toegang tot de manager interface aan of uit te zetten. <strong>Let op: Als deze op nee is ingesteld dan zal de gebruiker naar de Manager Login of Site startpagina gestuurd worden</strong>';

$_lang['setting_failed_login'] = 'Mislukte inlog pogingen';
$_lang['setting_failed_login_desc'] = 'Hier kun je het aantal keren foutief inloggen definieren waarna een gebruiker geblokkeerd wordt.';

$_lang['setting_login_allowed_days'] = 'Dagen toegestaan';
$_lang['setting_login_allowed_days_desc'] = 'Selecteer het aantal dagen zolang de gebruiker mag inloggen.';

$_lang['setting_login_allowed_ip'] = 'Toegestaan IP adres';
$_lang['setting_login_allowed_ip_desc'] = 'Vul het IP adres in van waar de gebruiker mag inloggen. <strong>Let op: verdeel meerdere IP adressen middels een komma (,)</strong>';

$_lang['setting_login_homepage'] = 'Inlogpagina';
$_lang['setting_login_homepage_desc'] = 'Vul het ID van het document in waar ed gebruiker naartoe gestuurd wordt nadat hij/zij ingelogd is. <strong>Let op: controleer dat het ID dat je invult behoort bij een geldig document en bereikbaar is voor deze gebruiker!</strong>';

// system settings
$_lang['setting_allow_duplicate_alias'] = 'Alias duplicaten toestaan';
$_lang['setting_allow_duplicate_alias_desc'] = 'Indien ingesteld op \'Ja\', dan zijn er dezelfde aliassen mogelijk bij het opslaan. <strong>Let op: deze optie alleen gebruiken als \'Vriendelijk alias pad\' optie is ingesteld op \'Ja\' om problemen met de referentie aan een document te voorkomen.</strong>';

$_lang['setting_allow_tags_in_post'] = 'HTML tags in POST toestaan';
$_lang['setting_allow_tags_in_post_desc'] = 'Indien onwaar, alle POST acties in de manager strippen elke html tag eruit. MODx beveelt aan om deze op waar te laten staan.';

$_lang['setting_archive_with'] = 'Forceer PCLZip Archieven';
$_lang['setting_archive_with_desc'] = 'Indien waar, dan wordt de PCLZip gebruikt in plaats van ZipArchive als zip extentie. Zet dit aan als je uitpak-errors krijgt of problemen hebt met uitpakken in de Pakket Manager.';

$_lang['setting_auto_menuindex'] = 'Standaard Menu indexing';
$_lang['setting_auto_menuindex_desc'] = 'Selecteer \'Ja\' om standaard automatische menu index doortelling in te schakelen.';

$_lang['setting_auto_check_pkg_updates'] = 'Automatisch controleren op pakket updates';
$_lang['setting_auto_check_pkg_updates_desc'] = 'Indien \'Ja\', MODx zal automatisch controleren op updates voor pakketjes in de Pakket Manager. Hierdoor zal het laden van het overzicht langer duren.';

$_lang['setting_auto_check_pkg_updates_cache_expire'] = 'Cache verlooptijd voor automatisch pakket update controle';
$_lang['setting_auto_check_pkg_updates_cache_expire_desc'] = 'Het aantal minuten dat de Pakket Manager de update resultaten in de cache houdt.';

$_lang['setting_allow_multiple_emails'] = 'Toestaan dubbele e-mailadressen voor gebruikers';
$_lang['setting_allow_multiple_emails_desc'] = 'Indien ingeschakeld, gebruikers mogen hetzelfde e-mailadressen hebben.';

$_lang['setting_automatic_alias'] = 'Automatisch aliassen genereren';
$_lang['setting_automatic_alias_desc'] = 'Selecteer \'Ja\' om het systeem automatisch een alias te laten genereren aan de hand van de document titel bij het opslaan.';

$_lang['setting_blocked_minutes'] = 'Geblokkeerde minuten';
$_lang['setting_blocked_minutes_desc'] = 'Hier kun je het aantal minuten definieren dat een gebruiker geblokkeerd is na het bereiken van het maximale aantal foutieve inlogpogingen. Vul alleen cijfers in (geen komma\'s, spaties etc.)';

$_lang['setting_cache_action_map'] = 'Actie Map Cache inschakelen';
$_lang['setting_cache_action_map_desc'] = 'Indien ingeschakeld, acties (of controller maps) worden gecached om de laadtijd van de manager te beforderen.';

$_lang['setting_cache_context_settings'] = 'Context Instellingen Cache';
$_lang['setting_cache_context_settings_desc'] = 'Indien ingeschakeld, context instellingen worden gecached om de laadtijd te bevorderen.';

$_lang['setting_cache_db'] = 'Database Cache inschakelen';
$_lang['setting_cache_db_desc'] = 'Indien ingeschakeld, objects en ruwe resultaatsets van SQL queries worden gecached om de snelheid significant te verbeteren.';

$_lang['setting_cache_db_expires'] = 'Verlooptijd voor Database Cache';
$_lang['setting_cache_db_expires_desc'] = 'Deze waarde (in seconden) stelt de verlooptijd voor de laatste cache bestanden van de database in.';

$_lang['setting_cache_default'] = 'Cacheable standaard';
$_lang['setting_cache_default_desc'] = 'Stel in op \'Ja\' om alle nieuwe documenten standaard cacheable te maken.';
$_lang['setting_cache_default_err'] = 'Vermeld of je standaard wilt dat documenten worden gecached.';

$_lang['setting_cache_disabled'] = 'Uitschakelen globale Cache opties';
$_lang['setting_cache_disabled_desc'] = 'Selecteer \'Ja\' om alle MODx caching functionaliteit uit te schakelen. MODx raad het niet aan dit uit te zetten.';
$_lang['setting_cache_disabled_err'] = 'Vermeld of je wilt dat cache ingeschakeld moet zijn.';

$_lang['setting_cache_json'] = 'Cache JSON Data';
$_lang['setting_cache_json_desc'] = 'Cache elke JSON data verstuurd naar of van de manager UI.';

$_lang['setting_cache_expires'] = 'Verlooptijd van standaard Cache';
$_lang['setting_cache_expires_desc'] = 'Deze waarde (in seconden) stelt de verlooptijd voor de laatste cache bestanden van de standaard in.';

$_lang['setting_cache_json_expires'] = 'Verlooptijd van JSON Cache';
$_lang['setting_cache_json_expires_desc'] = 'Deze waarde (in seconden) stelt de verlooptijd voor de laatste cache bestanden van JSON in.';

$_lang['setting_cache_handler'] = 'Caching Handler Class';
$_lang['setting_cache_handler_desc'] = 'De class naam van het type handler te gebruiken voor caching.';

$_lang['setting_cache_lang_js'] = 'Cache Lexicon JS Strings';
$_lang['setting_cache_lang_js_desc'] = 'Indien op waar ingesteld, zal dit server headers gebruiken om de lexicon strings geladen in Javascript voor de manager interface te cachen.';

$_lang['setting_cache_lexicon_topics'] = 'Cache Lexicon Topics';
$_lang['setting_cache_lexicon_topics_desc'] = 'Indien ingeschakeld, alle Lexicon topics zullen gecached worden om de laadtijd van de internationalisatie functionaliteit sterk te verbeteren. MODx beveelt ten strengste aan dit op \'Ja\' te laten staan.';

$_lang['setting_cache_noncore_lexicon_topics'] = 'Cache Non-Core Lexicon Topics';
$_lang['setting_cache_noncore_lexicon_topics_desc'] = 'Indien uitgeschakeld, niet-core Lexicon topics worden niet gecached. Dit kan handig zijn als je je eigen extra\'s ontwikkeld.';

$_lang['setting_cache_resource'] = 'Inschakelen gedeeltelijke document Cache';
$_lang['setting_cache_resource_desc'] = 'Gedeeltelijke document caching is configureerbaar per document als deze functionaliteit ingeschakeld is. Uitschakelen zal het globaal uitzetten.';

$_lang['setting_cache_resource_expires'] = 'Verlooptijd voor gedeeltelijke document Cache';
$_lang['setting_cache_resource_expires_desc'] = 'Deze waarde (in seconden) stelt de verlooptijd voor de laatste cache bestanden van de gedeeltelijke documenten in.';

$_lang['setting_cache_scripts'] = 'Inschakelen Script Cache';
$_lang['setting_cache_scripts_desc'] = 'Indien ingeschakeld, MODx zal alle scripts cachen (snippets en plugins) naar een bestand om de laadtijd te verbeteren. MODx beveelt aan deze op \'Ja\' ingesteld te laten.';

$_lang['setting_cache_system_settings'] = 'Inschakelen Systeeminstellingen Cache';
$_lang['setting_cache_system_settings_desc'] = 'Indien ingeschakeld, systeeminstellingen worden gecached om laadtijd te verbeteren. MODx beveelt aan om dit aan te laten staan.';

$_lang['setting_compress_css'] = 'Gebruik Gecomprimeerde CSS';
$_lang['setting_compress_css_desc'] = 'Indien ingeschakeld, MODx zal een gecomprimeerde versie van zijn css stylesheets gebruiken in de manager interface. Dit reduceert de laadtijd enorm in de manager. Schakel deze alleen uit als je aanpassingen verricht aan core elementen.';

$_lang['setting_compress_js'] = 'Gebruik Gecomprimeerde Javascript Libraries';
$_lang['setting_compress_js_desc'] = 'Indien ingeschakeld, MODx zal een gecomprimeerde versie van zijn Javascript libraries gebruiken in de manager interface. Dit reduceert de laadtijd enorm in de manager. Schakel deze alleen uit als je aanpassingen verricht aan core elementen.';

$_lang['setting_concat_js'] = 'Gebruik Samengevoegde Javascript Libraries';
$_lang['setting_concat_js_desc'] = 'Indien ingeschakeld, MODx zal een samengevoegde versie gebruiken van zijn Javascript libraries in de manager interface. Dit reduceert de laadtijd enorm in de manager. Schakel deze alleen uit als je aanpassingen verricht aan core elementen.';

$_lang['setting_container_suffix'] = 'Container Achtervoegsel';
$_lang['setting_container_suffix_desc'] = 'Het achtervoegsel voor documenten indien het containers zijn en als er gebruikt gemaakt wordt van FURLs.';

$_lang['setting_cultureKey'] = 'Taal';
$_lang['setting_cultureKey_desc'] = 'Selecteer de taal voor alle niet-manager Contexts, inclusief web.';

$_lang['setting_custom_resource_classes'] = 'Aangepaste Document Classes';
$_lang['setting_custom_resource_classes_desc'] = 'Een komma-gescheiden lijst van aangepaste document classes. Specificeer met kleine letters de lexicon_sleutel:className (vb: wiki_resource:WikiResource). Alle classes moeten extenden van modResource. Om de locatie van de controller te specificeren voor elke class, voeg een instelling toe met kleine letters [deNaamVanDeClass]_delegate_path met een pad naar de map met de php maak/wijzig bestanden. Vb: wikiresource_delegate_path voor de class WikiResource welke modResource extend.';

$_lang['setting_default_template'] = 'Standaard Template';
$_lang['setting_default_template_desc'] = 'Selecteer de standaard template welke je wilt gebruiken voor nieuwe documenten. Uiteraard kun je altijd nog een andere template kiezen in de document-editor, deze instelling selecteert er alvast een voor jou.';

$_lang['setting_default_per_page'] = 'Standaard Per Pagina';
$_lang['setting_default_per_page_desc'] = 'Het standaard aantal rijen per pagina dat gebruikt wordt in overzichten in de manager.';

$_lang['setting_editor_css_path'] = 'Pad naar CSS bestand';
$_lang['setting_editor_css_path_desc'] = 'Vul een pad in naar jouw CSS bestand dat je wilt gebruiken in een richtekst editor. De beste manier om het pad in te voeren is vanaf de root van jouw installatie, bijvoorbeeld: /assets/site/style.css. Indien je geen CSS wilt laden in de richtekst editor, laat dit veld dan leeg.';

$_lang['setting_editor_css_selectors'] = 'CSS Selectors voor de editor';
$_lang['setting_editor_css_selectors_desc'] = 'Een komma-gescheiden lijst van CSS selectors voor de richtext editor.';

$_lang['setting_emailsender'] = 'Registratie e-mail from adres';
$_lang['setting_emailsender_desc'] = 'Vul hier het e-mailadres in dat gebruikt wordt voor het versturen van de gebruikers zijn gebruikersnaam en wachtwoord.';
$_lang['setting_emailsender_err'] = 'Vermeld het e-mailadres voor het e-mail bericht aan gebruikers.';

$_lang['setting_emailsubject'] = 'Registratie e-mail onderwerp';
$_lang['setting_emailsubject_desc'] = 'Het onderwerp voor de standaard inschrijf e-mail wanneer een gebruiker zich aanmeldt.';
$_lang['setting_emailsubject_err'] = 'Vermeld een onderwerp voor de inschrijf e-mail.';

$_lang['setting_enable_dragdrop'] = 'Schakel drag/drop in voor document/element boomstructuren';
$_lang['setting_enable_dragdrop_desc'] = 'Als uit, voorkom dan slepen en neerzetten in de document en element boomstructuur.';

$_lang['setting_error_page'] = 'Foutpagina';
$_lang['setting_error_page_desc'] = 'Vul het ID in van het document jij wilt dat gebruikers naar doorgestuurd worden als een document verzoek niet gevonden kan worden. <strong>Let op: controleer dat dit ID behoort tot een geldig document en dat deze gepubliceerd is!</strong>';
$_lang['setting_error_page_err'] = 'Specificeer een document ID voor de foutpagina.';

$_lang['setting_extension_packages'] = 'Pakket Extensies';
$_lang['setting_extension_packages_desc'] = 'Een komma-gescheiden list van te laden pakketjes in de MODx installatie. In het formaat pakketnaam:padnaarmodel';

$_lang['setting_failed_login_attempts'] = 'Foutieve Inlogpogingen';
$_lang['setting_failed_login_attempts_desc'] = 'Het aantal foutieve inlogpogingen waarna een gebruiker \'geblokkeerd\' wordt.';

$_lang['setting_fe_editor_lang'] = 'Front-end editor taal';
$_lang['setting_fe_editor_lang_desc'] = 'Kies een taal voor de editor wanneer je een front-end editor gebruikt.';

$_lang['setting_feed_modx_news'] = 'MODx Nieuws Feed URL';
$_lang['setting_feed_modx_news_desc'] = 'Stel de URL in voor de RSS feed voor het MODx Nieuws paneel in de manager.';

$_lang['setting_feed_modx_news_enabled'] = 'MODx Nieuws Feed Ingeschakeld';
$_lang['setting_feed_modx_news_enabled_desc'] = 'Indien \'Nee\', MODx zal het Nieuws blok verbergen op het welkomstscherm van de manager.';

$_lang['setting_feed_modx_security'] = 'MODx Beveiliginsberichten Feed URL';
$_lang['setting_feed_modx_security_desc'] = 'Stel de URL in voor de RSS feed voor hey MODx beveiligingsberichten paneel in de manager.';

$_lang['setting_feed_modx_security_enabled'] = 'MODx Beveiligings Feed Ingeschakeld';
$_lang['setting_feed_modx_security_enabled_desc'] = 'Indien \'Nee\', MODx zal het Beveiligings blok verbergen op het welkomstscherm van de manager.';

$_lang['setting_filemanager_path'] = 'Bestandsmanager pad';
$_lang['setting_filemanager_path_desc'] = 'IIS heeft moeite met het goed instellen van de document_root instelling, welke door de bestandsmanager gebruikt wordt zodat bepaald wordt wat jij te zien krijgt. Indien je problemen ondervindt in de bestandsmanager, controleer of dit pad naar de root van jouw MODx installatie gaat.';

$_lang['setting_filemanager_url'] = 'Bestandsmanager URL';
$_lang['setting_filemanager_url_desc'] = 'Optioneel. Stel deze in als je een expliciete URL wilt gebruiken voor de bestanden in de MODx bestandsmanager (handig als je het filemanager_path naar een pad buiten de MODx webroot hebt veranderd). Controleer wel of dit een web-bereikbare URL van de filemanager_path is. Als je deze leeg laat zal MODx proberen dit pad automatisch te berekenen.';

$_lang['setting_forgot_login_email'] = 'Inlog vergeten e-mail';
$_lang['setting_forgot_login_email_desc'] = 'Het template voor de e-mail welke gestuurd wordt zodra een gebruiker zijn MODx gebruikersnaam/wachtwoord vergeten is';

$_lang['setting_friendly_alias_lowercase_only'] = 'FURL Kleine letter aliassen';
$_lang['setting_friendly_alias_lowercase_only_desc'] = 'Bepaal of er alleen kleine letters in een document alias gebruikt mag worden.';

$_lang['setting_friendly_alias_max_length'] = 'FURL Maximale alias lengte';
$_lang['setting_friendly_alias_max_length_desc'] = 'Indien groter dan nul, het maximale aantal tekens dat gebruikt voor een document alias. Nul is gelijk aan ongelimiteerd.';

$_lang['setting_friendly_alias_restrict_chars'] = 'FURL Beperking alias karakter methode';
$_lang['setting_friendly_alias_restrict_chars_desc'] = 'De methode wordt gebruikt om het aantal karakters te beperken in een document alias. "pattern" staat een RegEx patroon toe, "legal" staat elk geldig URL karakter toe, "alpha" staat alleen letters uit het alfabet toe en "alphanumeric" staat alleen letters en cijfers toe.';

$_lang['setting_friendly_alias_restrict_chars_pattern'] = 'FURL beperkingspatroon alias karakter';
$_lang['setting_friendly_alias_restrict_chars_pattern_desc'] = 'Een geldig RegEx patroon voor het beperken van karakters in een document alias.';

$_lang['setting_friendly_alias_strip_element_tags'] = 'FURL alias strip element tags';
$_lang['setting_friendly_alias_strip_element_tags_desc'] = 'Bepaal of element tags gestript moeten worden van een document alias.';

$_lang['setting_friendly_alias_translit'] = 'FURL alias transliteratie';
$_lang['setting_friendly_alias_translit_desc'] = 'De methode voor transliteratie die wordt gebruikt op een alias van een document. Leeg of "none" is de standaard waarde welke transliteratie overslaat. Andere mogelijke waarden zijn "iconv" (indien beschikbaar) of een naam van een transliteratie tabel, geleverd door een aangepaste transliteratie service class.';

$_lang['setting_friendly_alias_translit_class'] = 'FURL alias transliteration service class';
$_lang['setting_friendly_alias_translit_class_desc'] = 'Een optionele service class welke een aangepaste transliteratie service bied voor de FURL Alias generator/filtering.';

$_lang['setting_friendly_alias_trim_chars'] = 'FURL trim alias karakters';
$_lang['setting_friendly_alias_trim_chars_desc'] = 'Karakters welke aan het eind van de een document alias weggehaald worden.';

$_lang['setting_friendly_alias_urls'] = 'Gebruik vriendelijke aliassen';
$_lang['setting_friendly_alias_urls_desc'] = 'Indien je vriendelijke URLs gebruikt en het document heeft een alias, dan heeft de alias altijd voorrang op de vriendelijke URL. Indien deze instelling op \'Ja\' gezet wordt, de content-type achtervoegsel van het document wordt dan toegevoegd aan de alias. Ter voorbeeld, jouw document met ID 1 heeft een alias als \'introductie\', en je hebt een content-type achtervoegsel als \'.html\', dan zal deze instelling \'introductie.html\' genereren. Indien er geen alias is, dan zal MODx \'1.html\' genereren als link.';

$_lang['setting_friendly_alias_word_delimiter'] = 'FURL scheidingsteken alias';
$_lang['setting_friendly_alias_word_delimiter_desc'] = 'Het voorkeurs scheidingsteken voor de woorden in de alias voor vriendelijke URLs.';

$_lang['setting_friendly_alias_word_delimiters'] = 'FURL scheidingsteken alias';
$_lang['setting_friendly_alias_word_delimiters_desc'] = 'De karakters welke scheidingstekens voor vriendelijke URL aliassen gebruikt worden. Deze tekens worden omgezet en geconsolideerd om de gewenste FURL alias scheidingsteken te maken.';

$_lang['setting_friendly_urls'] = 'Gebruik vriendelijke URLs';
$_lang['setting_friendly_urls_desc'] = 'Dit staat je toe om zoekmachine vriendelijke URLs te gebruiken met MODx. Let op: dit zal alleen werken in MODx installaties draaiend op Apache en je moet een .htaccess bestand gemaakt hebben om dit te laten werken. Bekijk de .htaccess bestand welke is meegeleverd voor meer info.';
$_lang['setting_friendly_urls_err'] = 'Vul in of je wel of niet gebruik wilt maken van vriendelijke URLs.';

$_lang['setting_mail_charset'] = 'Mail Karakterset';
$_lang['setting_mail_charset_desc'] = 'Het (standaard) karakterset voor e-mails, bijv. \'iso-8859-1\' of \'UTF-8\'';

$_lang['setting_mail_encoding'] = 'Mail Encoding';
$_lang['setting_mail_encoding_desc'] = 'Stelt de encoding in van het bericht. Mogelijkheden voor dit zijn "8bit", "7bit", "binary", "base64" en "quoted-printable".';

$_lang['setting_mail_use_smtp'] = 'Gebruik SMTP';
$_lang['setting_mail_use_smtp_desc'] = 'Indien waar, MODx zal probren SMTP te gebruiken in mail functionaliteiten.';

$_lang['setting_mail_smtp_auth'] = 'SMTP Authenticatie';
$_lang['setting_mail_smtp_auth_desc'] = 'Stelt SMTP authenticatie in. Maakt gebruik van de mail_smtp_user en mail_smtp_pass instellingen.';

$_lang['setting_mail_smtp_helo'] = 'SMTP Helo Bericht';
$_lang['setting_mail_smtp_helo_desc'] = 'Stelt de SMTP HELO in van het bericht (Standaard de hostnaam).';

$_lang['setting_mail_smtp_hosts'] = 'SMTP Hosts';
$_lang['setting_mail_smtp_hosts_desc'] = 'Stelt de SMTP host in. Alle hosts moeten worden gescheiden door een puntcomma. Je kunt ook een andere poort gebruiken voor elke host, in dit formaat: [hostnaam:poort] (bijv. "smtp1.example.com:25;smtp2.example.com"). Hosts worden op volgorde gebruikt.';

$_lang['setting_mail_smtp_keepalive'] = 'SMTP Keep-Alive';
$_lang['setting_mail_smtp_keepalive_desc'] = 'Voorkomt dat de SMTP-verbinding wordt gesloten na elke gestuurde e-mail. Niet aanbevolen.';

$_lang['setting_mail_smtp_pass'] = 'SMTP wachtwoord';
$_lang['setting_mail_smtp_pass_desc'] = 'Het wachtwoord voor de authenticatie voor de SMTP.';

$_lang['setting_mail_smtp_port'] = 'SMTP poort';
$_lang['setting_mail_smtp_port_desc'] = 'Stel de standaard SMTP poort in.';

$_lang['setting_mail_smtp_prefix'] = 'SMTP verbinding voorvoegsel';
$_lang['setting_mail_smtp_prefix_desc'] = 'Stel het voorvoegsel van de verbinding in. Mogelijk zijn "", "ssl" of "tls"';

$_lang['setting_mail_smtp_single_to'] = 'SMTP Single To';
$_lang['setting_mail_smtp_single_to_desc'] = 'Biedt de mogelijkheid om e-mail berichten afzonderlijk te sturen in plaats van het versturen naar alle \'naar\' adressen.';

$_lang['setting_mail_smtp_timeout'] = 'SMTP Timeout';
$_lang['setting_mail_smtp_timeout_desc'] = 'Stel de SMTP server timeout in, in seconden. Deze functionaliteit zal niet werken op win32 servers.';

$_lang['setting_mail_smtp_user'] = 'SMTP Gebruiker';
$_lang['setting_mail_smtp_user_desc'] = 'De gebruikersnaam voor de authenticatie voor de SMTP.';

$_lang['setting_manager_direction'] = 'Manager tekstrichting';
$_lang['setting_manager_direction_desc'] = 'Kies de richting waarin de tekst getoond moet worden in de manager, van links naar rechts of van rechts naar links.';

$_lang['setting_manager_date_format'] = 'Manager Datumformaat';
$_lang['setting_manager_date_format_desc'] = 'Het formaat, in PHP date() formaat, voor de datums vertegenwoordigd in de manager.';

$_lang['setting_manager_lang_attribute'] = 'Manager HTML en XML taal attribuut';
$_lang['setting_manager_lang_attribute_desc'] = 'Vul een taalcode in dat het beste past bij de gekozen manager taal, dit zal ervoor zorgen dat de browser de content in een zo goed mogelijk formaat kan tonen.';

$_lang['setting_manager_language'] = 'Manager taal';
$_lang['setting_manager_language_desc'] = 'Selecteer de taal voor de MODx content manager.';

$_lang['setting_manager_login_start'] = 'Manager inlog start';
$_lang['setting_manager_login_start_desc'] = 'Vul het ID in van het document waar de gebruiker naartoe gestuurd moet worden zodra hij/zij inlogt in de manager. <strong>Let op: controleer of het ID behoort tot een bestaand document en dat het gepubliceerd is en bereikbaar voor deze gebruiker!</strong>';

$_lang['setting_manager_theme'] = 'Manager Thema';
$_lang['setting_manager_theme_desc'] = 'Selecteer een thema voor de content manager.';

$_lang['setting_manager_time_format'] = 'Manager Tijdsformaat';
$_lang['setting_manager_time_format_desc'] = 'Het formaat, in PHP date(), voor de tijd instellingen getoond in de manager.';

$_lang['setting_manager_use_tabs'] = 'Gebruik tabs in de manager layout';
$_lang['setting_manager_use_tabs_desc'] = 'Indien waar, de manager zal tabs gebruiken voor het renderen van de content panelen. Anders gebruikt het portalen.';

$_lang['setting_modRequest.class'] = 'Request Handler Class';
$_lang['setting_modRequest.class_desc'] = '';

$_lang['setting_modx_charset'] = 'Karakter encoding';
$_lang['setting_modx_charset_desc'] = 'Selecteer welek karakter encoding je wilt gebruiken. Onthoud dat MODx is getest met een aantal van deze encodings, maar niet met alle. Voor de meeste talen is de standaard instelling UTF-8 de voorkeur.';

$_lang['setting_new_file_permissions'] = 'Nieuwe bestandsrechten';
$_lang['setting_new_file_permissions_desc'] = 'Wanneer een nieuw bestand geupload wordt in de bestandsmanager, zal de bestandsmanager proberen de rechten van het bestand te veranderen naar deze instelling. Dit werkt niet op alle omgevingen, zoals IIS. In dat geval moet je zelf handmatig de rechten aanpassen.';

$_lang['setting_new_folder_permissions'] = 'Nieuwe maprechten';
$_lang['setting_new_folder_permissions_desc'] = 'Wanneer een nieuwe map toegeoegd wordt in de bestandsmanager, zal de bestandsmanager proberen de rechten van de map te veranderen naar deze instelling. Dit werkt niet op alle omgevingen, zoals IIS. In dat geval moet je zelf handmatig de rechten aanpassen.';

$_lang['setting_password_generated_length'] = 'Lengte auto-gegenereerde wachtwoorden';
$_lang['setting_password_generated_length_desc'] = 'De lengte van de auto-gegenereerde wachtwoorden voor een gebruiker.';

$_lang['setting_proxy_auth_type'] = 'Proxy Authenticatie Type';
$_lang['setting_proxy_auth_type_desc'] = 'Ondersteund BASIC of NTLM.';

$_lang['setting_proxy_host'] = 'Proxy Host';
$_lang['setting_proxy_host_desc'] = 'Als jouw server gebruik maakt van een proxy, stel de hostnaam hier in om bepaalde functionaliteiten van MODx te activeren welke een proxy gebruiken, zoals de Pakket Manager.';

$_lang['setting_proxy_password'] = 'Proxy wachtwoord';
$_lang['setting_proxy_password_desc'] = 'Het wachtwoord nodig voor authenticatie van de proxy server.';

$_lang['setting_proxy_port'] = 'Proxy poort';
$_lang['setting_proxy_port_desc'] = 'De poort voor jouw proxy server.';

$_lang['setting_proxy_username'] = 'Proxy gebruikersnaam';
$_lang['setting_proxy_username_desc'] = 'De gebruikersnaam nodig voor authenticatie van de proxy server.';

$_lang['setting_password_min_length'] = 'Minimale wachtwoord lengte';
$_lang['setting_password_min_length_desc'] = 'De minimale lengte van een wachtwoord voor een gebruiker.';

$_lang['setting_phpthumb_cache_maxage'] = 'phpThumb maximale cache leeftijd';
$_lang['setting_phpthumb_cache_maxage_desc'] = 'Verwijder gecachte thumbnails welke niet opgeroepen zijn meer dan X dagen.';

$_lang['setting_phpthumb_cache_maxsize'] = 'phpThumb maximale cache grootte';
$_lang['setting_phpthumb_cache_maxsize_desc'] = 'Verwijder minst onlangs benaderde thumbnails wanneer de cache groter is dan X megabytes.';

$_lang['setting_phpthumb_cache_maxfiles'] = 'phpThumb maximale cache bestanden';
$_lang['setting_phpthumb_cache_maxfiles_desc'] = 'Verwijder minst onlangs benaderde thumbnails wanneer de cache meer dan X bestanden heeft.';

$_lang['setting_phpthumb_cache_source_enabled'] = 'phpThumb cache bronbestanden';
$_lang['setting_phpthumb_cache_source_enabled_desc'] = 'Wel of niet cachen van bronbestanden zodra ze geladen zijn. Uit is aanbevolen.';

$_lang['setting_phpthumb_imagemagick_path'] = 'phpThumb ImageMagick pad';
$_lang['setting_phpthumb_imagemagick_path_desc'] = 'Optioneel. Stel een alternatief ImageMagick pad in voor het genereren van de thumbnails met phpThumb, als het niet in de PHP standaard opgenomen is.';

$_lang['setting_phpthumb_zoomcrop'] = 'phpThumb Zoom-Crop';
$_lang['setting_phpthumb_zoomcrop_desc'] = 'De standaard zoom-crop instelling voor phpThumb bij gebruik in MODx. Standaard op 0 om zoom-crop te voorkomen.';

$_lang['setting_phpthumb_far'] = 'phpThumb behoud verhoudingen forceren';
$_lang['setting_phpthumb_far_desc'] = 'De standaard instelling voor zover phpThumb bij gebruik in MODx. Standaard C tot verhouding in de richting van het midden.';

$_lang['setting_publish_default'] = 'Standaard gepubliceerd';
$_lang['setting_publish_default_desc'] = 'Selecteer \'Ja\' om alle nieuwe documenten standaard gepubliceerd te maken.';
$_lang['setting_publish_default_err'] = 'Vul in om wel of niet documenten standaard gepubliceerd te maken.';

$_lang['setting_rb_base_dir'] = 'Document pad';
$_lang['setting_rb_base_dir_desc'] = 'Vul een fysiek pad in naar een document map. Deze instelling wordt normaal gesproken automatisch gegenereerd. Echter als je IIS gebruikt zal MODx niet in staat zijn het pad goed te genereren, dit veroorzaakt problemen met de document browser. In dat geval, kun je een pad naar de afbeeldingen map hier instellen (zoals je die ziet in Windows Explorer). <strong>Let op:</strong> De documentmap moet een submap images, files, flash en media bevatten om de browser goed te laten werken.';
$_lang['setting_rb_base_dir_err'] = 'Vul een document browser basis map in.';
$_lang['setting_rb_base_dir_err_invalid'] = 'Dit document bestaat niet of kan niet bereikt worden. Vul een geldige map in of pas de rechten van die map aan.';

$_lang['setting_rb_base_url'] = 'Document URL';
$_lang['setting_rb_base_url_desc'] = 'Vul een virtueel pad in naar de documentmap. Deze instelling wordt normaal gesproken automatisch gegenereerd. Echter als je IIS gebruikt zal MODx niet in staat zijn het pad goed te genereren, dit veroorzaakt problemen met de document browser. In dat geval, kun je een URL naar de afbeeldingen map hier instellen (zoals je die ziet in Internet Explorer).';
$_lang['setting_rb_base_url_err'] = 'Vul een document browser basis URL in.';

$_lang['setting_request_controller'] = 'Request controller bestandsnaam';
$_lang['setting_request_controller_desc'] = 'De bestandsnaam van de hoofd request controller vanwaar MODx geladen is. De meeste gebruikers kunnen dit laten staan op index.php.';

$_lang['setting_request_param_alias'] = 'Request alias parameter';
$_lang['setting_request_param_alias_desc'] = 'De naam van de GET parameter om document aliassen te identificeren bij doorsturen met FURLs.';

$_lang['setting_request_param_id'] = 'Request ID Parameter';
$_lang['setting_request_param_id_desc'] = 'De naam van de GET parameter om document aliassen te identificeren zonder gebruik van FURLs.';

$_lang['setting_resolve_hostnames'] = 'Achterhalen hostnamen';
$_lang['setting_resolve_hostnames_desc'] = 'Wil je dat MODx probeert de hostnamen van jouw bezoekers te achterhalen wanneer deze jouw site bezoeken? Hostnamen achterhalen kan wellicht extra laadtijd veroorzaken, hoewel jouw bezoekers op geen enkele wijze bericht hiervan krijgen.';

$_lang['setting_richtext_default'] = 'Richtext standaard';
$_lang['setting_richtext_default_desc'] = 'Selecteer \'Ja\' om alle nieuwe documenten gebruik te laten maken van de richtekst editor.';

$_lang['setting_search_default'] = 'Standaard doorzoekbaar';
$_lang['setting_search_default_desc'] = 'Selecteer \'Ja\' om alle nieuwe documenten standaard doorzoekbaar in te stellen.';
$_lang['setting_search_default_err'] = 'Geef aan of documenten standaard doorzoekbaar moeten zijn of niet.';

$_lang['setting_server_offset_time'] = 'Server offset tijd';
$_lang['setting_server_offset_time_desc'] = 'Selecteer het aantal uren in tijdsverschil in waar jij bent en waar de server is.';

$_lang['setting_server_protocol'] = 'Server type';
$_lang['setting_server_protocol_desc'] = 'Als jouw site op een http verbinding draait, specificeer het hier.';
$_lang['setting_server_protocol_err'] = 'Geef aan of jouw site wel of niet een beveiligde site is';
$_lang['setting_server_protocol_http'] = 'http';
$_lang['setting_server_protocol_https'] = 'https';

$_lang['setting_session_cookie_domain'] = 'Sessie cookie domein';
$_lang['setting_session_cookie_domain_desc'] = 'Gebruik deze instelling om de sessie cookie domein aan te passen.';

$_lang['setting_session_cookie_lifetime'] = 'Sessie cookie verlooptijd';
$_lang['setting_session_cookie_lifetime_desc'] = 'Gebruik deze instelling om de sessie cookie verlooptijd in seconden aan te passen. Dit wordt gebruikt om de verlooptijd van de sessie cookie wanneer er gekozen wordt voor \'onthoud mij\' optie bij het inloggen.';

$_lang['setting_session_cookie_path'] = 'Sessie cookie pad';
$_lang['setting_session_cookie_path_desc'] = 'Gebruik deze instelling om het cookie pad aan te passen voor het identificeren van specifieke site sessie cookies';

$_lang['setting_session_cookie_secure'] = 'Sessie cookie beveiligd';
$_lang['setting_session_cookie_secure_desc'] = 'Activeer deze instelling om beveiligde cookies te gebruiken.';

$_lang['setting_session_handler_class'] = 'Sessie handler classnaam';
$_lang['setting_session_handler_class_desc'] = 'Voor database gestuurde sessies, gebruik \'modSessionHandler\'. Laat deze leeg voor de standaard PHP sessie management.';

$_lang['setting_session_name'] = 'Sessienaam';
$_lang['setting_session_name_desc'] = 'Gebruik deze instelling om de sessienaam voor gebruik in sessies in MODx aan te passen.';

$_lang['setting_settings_version'] = 'Instellingen Versie';
$_lang['setting_settings_version_desc'] = 'De huidig genstalleerde versie van MODx.';

$_lang['setting_set_header'] = 'Stel HTTP Headers in';
$_lang['setting_set_header_desc'] = 'Indien geactiveerd, MODx zal proberen de HTTP headers in te stellen voor documenten.';

$_lang['setting_signupemail_message'] = 'Inschrijf e-mail';
$_lang['setting_signupemail_message_desc'] = 'Hier kun je het e-mailbericht opstellen welke gestuurd wordt naar gebruikers wanneer je een account voor ze aanmaakt en MODx een e-mail laat sturen met de te gebruiken gebruikersnaam en wachtwoord.<br /><strong>Let op:</strong> de volgende placeholders worden vervangen door de Content Manager wanneer het bericht verstuurd wordt:<br /><br />[[+sname]] - Naam van jouw website<br />[[+saddr]] - Het standaard e-mailadres<br />[[+surl]] - Website URL<br />[[+uid]] - Gebruikers loginnaam of id<br />[[+pwd]] - Gebruikerswachtwoord<br />[[+ufn]] - Gebruikers volledige naam<br /><br />Laat de [[+uid]] en [[+pwd]] in het e-mailbericht, want anders wordt er geen gebruikersnaam en wachtwoord gestuurd en weet de gebruiker niet hoe hij/zij moet inloggen!</strong>';
$_lang['setting_signupemail_message_default'] = 'Hallo [[+uid]]\n\nHier zijn jouw logingegevens voor [[+sname]] Content Manager:\n\nGebruikersnaam: [[+uid]]\nWachtwoord: [[+pwd]]\n\nAls je inlogt in de Content Manager ([[+surl]]), kun je je wachtwoord wijzigen.\n\nMet vriendelijke groet,\nSite beheerder';

$_lang['setting_site_name'] = 'Site naam';
$_lang['setting_site_name_desc'] = 'Vul de naam van jouw site in!';
$_lang['setting_site_name_err']  = 'Vul een site naam in';

$_lang['setting_site_start'] = 'Site start';
$_lang['setting_site_start_desc'] = 'Vul het ID van het document in dat jij als startpagina wilt hebben. <strong>Let op:</strong> controleer of dit ID behoort tot een bestaand document en dat dit document gepubliceerd is!</strong>';
$_lang['setting_site_start_err'] = 'Vul een ID in welke de startpagina zal zijn.';

$_lang['setting_site_status'] = 'Site status';
$_lang['setting_site_status_desc'] = 'Selecteer \'Ja\' om de site beschikbaar te maken voor het web. Indien je \'Nee\' selecteert, jouw bezoekers zien dan een \'Site niet beschikbaar bericht\' en zijn niet in staat door de site te navigeren.';
$_lang['setting_site_status_err'] = 'Selecteer of jouw website wel (Ja) of niet (Nee) online is.';

$_lang['setting_site_unavailable_message'] = 'Site niet beschikbaar bericht';
$_lang['setting_site_unavailable_message_desc'] = 'Bericht te tonen wanneer de site offline is of wanneer er een fout optreed. <strong>Let op: Dit bericht wordt alleen getoont als de Site niet beschikbaar pagina optie niet ingesteld is.</strong>';

$_lang['setting_site_unavailable_page'] = 'Site niet beschikbaar pagina';
$_lang['setting_site_unavailable_page_desc'] = 'Vul een ID van een document dat je wilt gebruiker als offline pagina. <strong>Let op: controleer dat dit ID een geldig document ID is en dat het document gepubliceerd is!</strong>';
$_lang['setting_site_unavailable_page_err'] = 'Vul een document ID in voor de niet beschikbaar pagina.';

$_lang['setting_strip_image_paths'] = 'Herschrijf browser paden?';
$_lang['setting_strip_image_paths_desc'] = 'Als dit op \'Nee\' gezet is, MODx zal bestandsmanager geschreven src\'s (afbeeldingen, bestanden, flash, etc.) als absolute URLs. Relatieve URLs zijn nuttig indien je wenst de MODx installatie te verplaatsen, bijv. van staging naar een productie omgeving. Indien je niet weet wat dit inhoudt laat dit dan staan op \'Ja\'.';

$_lang['setting_topmenu_show_descriptions'] = 'Toon omschrijvingen in het topmenu';
$_lang['setting_topmenu_show_descriptions_desc'] = 'Als op \'No\' ingesteld is, MODx zal de omschrijvingen verbergen in het menu bovenin de manager.';

$_lang['setting_tree_root_id'] = 'Structuur Root ID';
$_lang['setting_tree_root_id_desc'] = 'Stel dit in naar een geldig ID van een document om boomstructuur aan de linkerkant te starten als root. De gebruiker zal alleen de documenten zien dat subs zijn van dit document.';

$_lang['setting_udperms_allowroot'] = 'Root toestaan';
$_lang['setting_udperms_allowroot_desc'] = 'Wil je gebruikers toestaan om nieuwe documenten te maken in de root van jouw site?';

$_lang['setting_unauthorized_page'] = 'Onbevoegde pagina';
$_lang['setting_unauthorized_page_desc'] = 'Vul het ID in van het document waar je gebruikers naar toe wilt sturen als ze een beveiligde of onbevoegde pagina opvragen. <strong>Let op: controleer of dit document ID bestaat en gepubliceerd is en toegankelijk is voor deze gebruiker!</strong>';
$_lang['setting_unauthorized_page_err'] = 'Vul een document ID in voor de onbevoegde pagina.';

$_lang['setting_upload_files'] = 'Uploadbare bestandstypen';
$_lang['setting_upload_files_desc'] = 'Hier kun je een lijst van bestandstypen invullen welke geupload kunnen worden in \'assets/files/\' bij gebruik van de document manager. Vul de extenties van de bestandstypen in gescheiden door een komma.';

$_lang['setting_upload_flash'] = 'Uploadbare Flashtypen';
$_lang['setting_upload_flash_desc'] = 'Hier kun je een lijst van bestandstypen invullen welke geupload kunnen worden in \'assets/flash/\' bij gebruik van de document manager. Vul de extenties van de bestandstypen in gescheiden door een komma.';

$_lang['setting_upload_images'] = 'Uploadbare afbeeldingstypen';
$_lang['setting_upload_images_desc'] = 'Hier kun je een lijst van bestandstypen invullen welke geupload kunnen worden in \'assets/images/\' bij gebruik van de document manager. Vul de extenties van de bestandstypen in gescheiden door een komma.';

$_lang['setting_upload_maxsize'] = 'Maximale upload grootte';
$_lang['setting_upload_maxsize_desc'] = 'Vul een maximale bestandsgrootte in dat geupload kan worden via de bestandsmanager. Upload grootte moet ingevuld worden in bytes. <strong>Let op: grote bestanden kunnen er lang over doen voordat ze geupload zijn!</strong>';

$_lang['setting_upload_media'] = 'Uploadbare mediatypen';
$_lang['setting_upload_media_desc'] = 'Hier kun je een lijst van bestandstypen invullen welke geupload kunnen worden in \'assets/media/\' bij gebruik van de document manager. Vul de extenties van de bestandstypen in gescheiden door een komma.';

$_lang['setting_use_alias_path'] = 'Gebruik vriendelijke aliaspaden';
$_lang['setting_use_alias_path_desc'] = 'Stel deze optie in op \'Ja\' zal een volledig pad tonen naar het document als het een alias heeft. Ter voorbeeld, als een document met een alias genaamd \'child\' in een container document zit met een alias genaamd \'parent\', dan is het volledige pad naar het document dat getoond word zoiets als \'parent/child.html\'<br /><strong>Let op: wanneer je deze instelling instelt op \'Ja\' (aanzetten aliaspaden), refereer items (zoals afbeeldingen, css, javascripts, etc.) middels gebruik van absolute paden: bijv., \'/assets/images\' in tegenstelling tot \'assets/images\'. Als je dit doet dan voorkom je dat de browser (of webserver) dat ze het pad toevoegen aan het alias pad.</strong>';

$_lang['setting_use_browser'] = 'Activeren document manager';
$_lang['setting_use_browser_desc'] = 'Selecteer \'Ja\' om de document manager te gebruiken. Dit zal jouw gebruikers toestaan om te bladeren en te uploaden van documenten zoals afbeeldingen, flash en media bestanden op de server.';
$_lang['setting_use_browser_err'] = 'Vul in of je wel of niet gebruik wilt maken van de document manager.';

$_lang['setting_use_editor'] = 'Activeer rich tekst editor';
$_lang['setting_use_editor_desc'] = 'Wil je gebruik van de rich tekst editor inschakelen? Als je je pretiger voelt met schrijven van HTML, dan kun je de editor uitzetten middels deze instelling. Let op dat deze instelling wordt toegepast op alle documenten en gebruikers!';
$_lang['setting_use_editor_err'] = 'Geef aan of je de RTE editor wel of niet wilt gebruiken.';

$_lang['setting_use_multibyte'] = 'Gebruik multibyte extensie';
$_lang['setting_use_multibyte_desc'] = 'Stel in op waar als je gebruik wilt maken van mbstring extentie voor multibyte karakters in jouw MODx installatie. Alleen op waar instellen als de mbstring PHP extentie genstalleerd is.';

$_lang['setting_webpwdreminder_message'] = 'Web herinneringsbericht';
$_lang['setting_webpwdreminder_message_desc'] = 'Hier kun je het e-mailbericht opstellen welke gestuurd wordt naar gebruikers wanneer ze een nieuw wachtwoord aanvragen. De Content Managr zal een e-mail sturen met het nieuwe wachtwoord en activatie informatie.<br /><strong>Let op:</strong> de volgende placeholders worden vervangen door de Content Manager wanneer het bericht verstuurd wordt:<br /><br />[[+sname]] - Naam van jouw website<br />[[+saddr]] - Het standaard e-mailadres<br />[[+surl]] - Website URL<br />[[+uid]] - Gebruikers loginnaam of id<br />[[+pwd]] - Gebruikerswachtwoord<br />[[+ufn]] - Gebruikers volledige naam<br /><br />Laat de [[+uid]] en [[+pwd]] in het e-mailbericht, want anders wordt er geen gebruikersnaam en wachtwoord gestuurd en weet de gebruiker niet hoe hij/zij moet inloggen!</strong>';
$_lang['setting_webpwdreminder_message_default'] = 'Hallo [[+uid]]\n\nOm je nieuwe wachtwoord te activeren, klik op de volgende link:\n\n[[+surl]]\n\nAls dit succesvol is kun je het volgende wachtwoord gebruiken om in te loggen:\n\nWachtwoord: [[+pwd]]\n\nAls je niet om een nieuw wachtwoord gevraagd hebt dan kun je dit bericht negeren.\n\nMet vriendelijke groet,\nSite beheerder';

$_lang['setting_websignupemail_message'] = 'Web Inschrijf e-mail';
$_lang['setting_websignupemail_message_desc'] = 'Hier kun je het e-mailbericht opstellen welke gestuurd wordt naar gebruikers wanneer je een account voor ze aanmaakt en MODx een e-mail laat sturen met de te gebruiken gebruikersnaam en wachtwoord.<br /><strong>Let op:</strong> de volgende placeholders worden vervangen door de Content Manager wanneer het bericht verstuurd wordt:<br /><br />[[+sname]] - Naam van jouw website<br />[[+saddr]] - Het standaard e-mailadres<br />[[+surl]] - Website URL<br />[[+uid]] - Gebruikers loginnaam of id<br />[[+pwd]] - Gebruikerswachtwoord<br />[[+ufn]] - Gebruikers volledige naam<br /><br />Laat de [[+uid]] en [[+pwd]] in het e-mailbericht, want anders wordt er geen gebruikersnaam en wachtwoord gestuurd en weet de gebruiker niet hoe hij/zij moet inloggen!</strong>';
$_lang['setting_signupemail_message_default'] = 'Hallo [[+uid]]\n\nHier zijn jouw logingegevens voor [[+sname]]:\n\nGebruikersnaam: [[+uid]]\nWachtwoord: [[+pwd]]\n\nAls je inlogt in de Content Manager ([[+surl]]), kun je je wachtwoord wijzigen.\n\nMet vriendelijke groet,\nSite beheerder';


$_lang['setting_welcome_screen'] = 'Toon welkomstscherm';
$_lang['setting_welcome_screen_desc'] = 'Indien op waar gezet, dan wordt het welkomstscherm wordt getoond bij het laden van de welkomstpagina en daarna niet meer.';

$_lang['setting_welcome_screen_url'] = 'Welkomstscherm URL';
$_lang['setting_welcome_screen_url_desc'] = 'De URL voor het welkomstscherm dat geladen wordt bij de eerste keer laden van MODx Revolution.';

$_lang['setting_which_editor'] = 'Te gebruiken editor';
$_lang['setting_which_editor_desc'] = 'Hier kun je selecteren welke rich tekst editor je wenst te gebruiken. Je kunt alternatieve rich tekst editors downloaden en installeren vai de Pakket Manager.';

$_lang['setting_which_element_editor'] = 'Te gebruiken editor voor elementen';
$_lang['setting_which_element_editor_desc'] = 'Hier kun je selecteren welke rich tekst editor je wenst te gebruiken om elemente te bewerken. Je kunt alternatieve rich tekst editors downloaden en installeren vai de Pakket Manager.';

$_lang['setting_xhtml_urls'] = 'XHTML URLs';
$_lang['setting_xhtml_urls_desc'] = 'Indien op waar gezet, alle URLs gegenereerd door MODx zijn XHTML-compliant, inclusief de encoding van het ampersand karakter.';